#!/bin/bash
# MPDWEB  & Tools,I/F Backup            Make: Mikio.Shiratori,2024.02.21
# user ;  suで実行 : Output./mpdweb_backup_set.tar.gz

if [ -d /var/www/html/mpdweb ]; then
	WEBTOP=/var/www/html
elif [ -d /var/www/mpdweb ]; then
	WEBTOP=/var/www/
else 
	echo "Not Instyall , mpdweb !! Abend"
	exit 1
fi

BACKUPBASE=.
BACKUP=${BACKUPBASE}/mpdweb_backup
mkdir ${BACKUP} &> /dev/null;chmod 0666 ${BACKUP}; &> /dev/null

TARFILE=mpdweb_backup.tar.gz
#SETUP=${BACKUPBASE}/mpdweb_restore_child.sh
SETUP=${BACKUP}/mpdweb_restore_child.sh

echo "#################################################"  > ${SETUP}
echo "# MPDWEB Restore ,setup use argv \${BACKUP}      #" >> ${SETUP}
echo "#################################################"  >> ${SETUP}
echo "WEBROOT=\"\""                     >> ${SETUP}
echo "if [ -d /usr/local/html ]; then"     >> ${SETUP}
echo "	WEBROOT=/usr/local/html"        >> ${SETUP}
echo "elif [ -d /var/www/html ]; then"     >> ${SETUP}
echo "	WEBROOT=/var/www/html"          >> ${SETUP}
echo "elif [ -d /var/www ]; then"          >> ${SETUP}
echo "	WEBROOT=/var/www"               >> ${SETUP}
echo "fi"                                  >> ${SETUP}

echo "if [ \$# = 0 ]; then"                >> ${SETUP}
echo "	BACKUP=${BACKUP}"                  >> ${SETUP}
echo "else"                                >> ${SETUP}
echo "	BACKUP=\$1"                        >> ${SETUP}
echo "fi"                                  >> ${SETUP}

echo "MPDWEB Backup"
# tar backup
tar -zcvf ${BACKUP}/${TARFILE} ${WEBTOP}/mpdweb

# ------------- install tool --------------------------------------------
if [ -e inst_tool.tar.gz ]; then
	tar -zxvf inst_tool.tar.gz
	chmod 0777 -R -f inst_tool
fi
# ------------- mpdweb Directory ----------------------------------------
echo "Check /mnt Directory"
echo "# MPDWEB mnt Directory"  >> ${SETUP}
if [ -d /mnt/NAS/music ]; then
	echo "Find /mnt/NAS/music"
	echo "if [ ! -d /mnt/NAS/music ]; then"                 >> ${SETUP}
	echo "	mkdir /mnt/NAS/music;chmod 0777 /mnt/NAS/music" >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi
if [ -d /mnt/playlists ]; then
	echo "Find /mnt/playlists"
	echo "if [ ! -d /mnt/playlists ]; then"                 >> ${SETUP}
	echo "	mkdir /mnt/playlists;chmod 0777 /mnt/playlists" >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi
if [ -d /mnt/ListArt ]; then
	echo "Find /mnt/ListArt"
	echo "if [ ! -d /mnt/ListArt ]; then"                   >> ${SETUP}
	echo "	mkdir /mnt/ListArt;chmod 0777 /mnt/ListArt"     >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi
if [ -d /mnt/PLSPlaylist ]; then
	echo "Find /mnt/PLSPlaylist"
	echo "if [ ! -d /mnt/PLSPlaylist ]; then"               >> ${SETUP}
	echo "	mkdir /mnt/PLSPlaylist"                         >> ${SETUP}
	echo "	mkdir /mnt/PLSPlaylist/PLS"                     >> ${SETUP}
	echo "	mkdir /mnt/PLSPlaylist/Image"                   >> ${SETUP}
	echo "	chmod 0777 -R -f /mnt/PLSPlaylist"              >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi
# ------------- Web MusicArt Directory -----------------------------------
if [ -d /usr/local/html/Music ]; then
	echo "Find /usr/local/html/Music"
	echo "if [ -n \"\${WEBROOT}\" ]&&[ ! -d \${WEBROOT}/ListArt ]&&[ -d /var/lib/mpd/music ]; then" >> ${SETUP}
	echo "	ln -s /var/lib/mpd/music/ \${WEBROOT}/Music" >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
elif [ -d ${WEBTOP}/Music ]; then
	echo "Find ${WEBTOP}/Music"
	echo "if [ ! -d \${WEBROOT}/Music ]&&[ -d /var/lib/mpd/music ]; then" >> ${SETUP}
	echo "ln -s /var/lib/mpd/music/ \${WEBROOT}/Music"   >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi

# ------------- ListArt Directory ----------------------------------------
if [ -d /usr/local/html/ListArt ]; then
	echo "Find /usr/local/html/ListArt"
	echo "if [ -n \"\${WEBROOT}\" ]&&[ ! -d \${WEBROOT}/ListArt ]&&[ -d /mnt/ListArt ]; then" >> ${SETUP}
	echo "	ln -s /mnt/ListArt \${WEBROOT}"              >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
elif [ -d ${WEBTOP}/ListArt ]; then
	echo "Find ${WEBTOP}/ListArt"
	echo "if [ ! -d \${WEBROOT}/ListArt ]&&[ -d /mnt/ListArt ]; then" >> ${SETUP}
	echo "ln -s /mnt/ListArt \${WEBROOT}" >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi

# ------------- PLSPlayer Directory --------------------------------------
if [ -d /usr/local/html/Image ]; then
	echo "Find /usr/local/html/Image"
	echo "if [ -n \"\${WEBROOT}\" ]&&[ ! -d \${WEBROOT}/Image ]&&[ -d /mnt/PLSPlaylist/Image ]; then" >> ${SETUP}
	echo "	ln -s /mnt/PLSPlaylist/Image \${WEBROOT}"    >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
elif [ -d ${WEBTOP}/Image ]; then
	echo "Find ${WEBTOP}/Image"
	echo "if [ ! -d \${WEBROOT}/Image ]&&[ -d /mnt/PLSPlaylist/Image ]; then" >> ${SETUP}
	echo "ln -s /mnt//mnt/PLSPlaylist/Image \${WEBROOT}" >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi

# ------------- mpdweb StartUP -------------------------------------------
echo "Check mpdmeb StartUP"
echo "#  mpdweb StartUP"     >> ${SETUP}
if systemctl is-enabled --quiet "mpdtask" || ls /etc/rc*.d/S??"mpdtask" >/dev/null 2>&1; then
	echo "Find mpdtask"
	echo "if [ -d /etc/init.d ]; then"                                        >> ${SETUP}
	echo "    if [ ! -e /etc/init.d/mpdtask ]&&[ -e \${WEBROOT}/mpdweb/init.d/mpdtask ]; then"  >> ${SETUP}
	echo "	      ln -s \${WEBROOT}/mpdweb/init.d/mpdtask /etc/init.d/mpdtask"                  >> ${SETUP}
	echo "    fi"                                                            >> ${SETUP}
	echo "	  systemctl enable mpdtask"                                      >> ${SETUP}
	echo "    /etc/init.d/mpdtask restart"                                   >> ${SETUP}
	echo "elif systemctl is-enabled --quiet mpdtask.service; then"           >> ${SETUP}
	echo "    systemctl enable \${WEBROOT}/mpdweb/service/mpdtask.service"   >> ${SETUP}
	echo "    systemctl restart mpdtask.service"                             >> ${SETUP}
	echo "else"                                                              >> ${SETUP}
	echo "    systemctl restart mpdtask.service"                             >> ${SETUP}
	echo "fi"                                                                >> ${SETUP}
fi

if systemctl is-enabled --quiet "mpdmount" || ls /etc/rc*.d/S??"mpdmount" >/dev/null 2>&1; then
	echo "Find mpdmount"
	echo "if [ -d /etc/init.d ]; then"                                        >> ${SETUP}
	echo "    if [ ! -e /etc/init.d/mpdmount ]&&[ -e \${WEBROOT}/mpdweb/init.d/mpdmount ]; then"  >> ${SETUP}
	echo "	      ln -s \${WEBROOT}/mpdweb/init.d/mpdmount /etc/init.d/mpdmount"                  >> ${SETUP}
	echo "    fi"                                                            >> ${SETUP}
	echo "	  systemctl enable mpdmount"                                     >> ${SETUP}
	echo "    /etc/init.d/mpdmount restart"                                  >> ${SETUP}
	echo "elif systemctl is-enabled --quiet mpdmount.service; then"          >> ${SETUP}
	echo "    systemctl enable \${WEBROOT}/mpdweb/service/mpdmount.service"  >> ${SETUP}
	echo "    systemctl restart mpdmount.service"                            >> ${SETUP}
	echo "else"                                                              >> ${SETUP}
	echo "    systemctl restart mpdmount.service"                            >> ${SETUP}
	echo "fi"                                                                >> ${SETUP}
fi

if systemctl is-enabled --quiet "mpdstartup" || ls /etc/rc*.d/S??"mpdstartup" >/dev/null 2>&1; then
	echo "Find mpdstartup"
	echo "if [ -d /etc/init.d ]; then"                                         >> ${SETUP}
	echo "    if [ ! -e /etc/init.d/mpdstartup ]&&[ -e \${WEBROOT}/mpdweb/init.d/mpdstartup ]; then"  >> ${SETUP}
	echo "	      ln -s \${WEBROOT}/mpdweb/init.d/mpdstartup /etc/init.d/mpdstartup"                  >> ${SETUP}
	echo "    fi"                                                             >> ${SETUP}
	echo "	  systemctl enable mpdstartup"                                    >> ${SETUP}
	echo "    /etc/init.d/mpdstartup restart"                                 >> ${SETUP}
	echo "elif systemctl is-enabled --quiet mpdstartup.service; then"         >> ${SETUP}
	echo "    systemctl enable \${WEBROOT}/mpdweb/service/mpdstartup.service" >> ${SETUP}
	echo "    systemctl restart mpdstartup.service"                           >> ${SETUP}
	echo "else"                                                              >> ${SETUP}
	echo "    systemctl restart mpdstartup.service"                           >> ${SETUP}
	echo "fi"                                                                 >> ${SETUP}
fi

# ------------- mpd.conf -------------------------------------------------
echo "Setting FIle Backup"
cp /etc/mpd.conf ${BACKUP}/mpd.conf
echo "if [ -e \${BACKUP}/mpd.conf ] ; then"                 >> ${SETUP}
echo "	if [ -e /etc/mpd.conf.org ] ; then"                 >> ${SETUP}
echo "		cp /etc/mpd.conf{,_\$(date +%Y%m%d%H%M%S)}"     >> ${SETUP}
echo "	else"                                               >> ${SETUP}
echo "		cp /etc/mpd.conf /etc/mpd.conf.org"             >> ${SETUP}
echo "	fi"                                                 >> ${SETUP}
echo "	cp \${BACKUP}/mpd.conf /etc/mpd.conf"               >> ${SETUP}
echo "	cp \${BACKUP}/mpd.conf /etc/mpd.conf.now"           >> ${SETUP}
echo "fi"                                                   >> ${SETUP}

# ------------- mpd Library ----------------------------------------------
echo "Setting mpd Library Backup"
echo "# Setting mpd Library"                                >> ${SETUP}
MPDMUSIC=`readlink /var/lib/mpd/music/NAS`
if [ "${MPDMUSIC}" == "/mnt/NAS" ] ; then
	echo "if [ ! -d /var/lib/mpd/music/NAS ]; then"         >> ${SETUP}
	echo "	ln -s /mnt/NAS /var/lib/mpd/music/NAS"          >> ${SETUP}
	echo "fi"                                               >> ${SETUP}
fi
MPDPLIST=`readlink /var/lib/mpd/playlists`
if [ "${MPDPLIST}" == "/mnt/playlists" ] ; then
	echo "MPDPLIST=\`readlink /var/lib/mpd/playlists\`"       >> ${SETUP}
	echo "if [ -d /var/lib/mpd/playlists ]&&[ -d /mnt/playlists ]; then"                   >> ${SETUP}
	echo "	if [ \"\${MPDPLIST}\" != \"/mnt/playlists\" ]; then"                           >> ${SETUP}
	echo "		if [ ! -d /var/lib/mpd/playlists.org ]; then"                              >> ${SETUP}
	echo "			mv /var/lib/mpd/playlists /var/lib/mpd/playlists.org"                  >> ${SETUP}
	echo "		else"                                                                      >> ${SETUP}
	echo "			mv /var/lib/mpd/playlists /var/lib/mpd/playlists_\$(date +%Y%m%d%H%M)" >> ${SETUP}
	echo "		fi"                                               >> ${SETUP}
	echo "		ln -s /mnt/playlists /var/lib/mpd/playlists"      >> ${SETUP}
	echo "	fi"                                               >> ${SETUP}
	echo "fi"                                                 >> ${SETUP}
fi
echo "# The standard environment is the same as Backup, restore the database"        >> ${SETUP}
echo "MPDMUSIC=\`readlink /var/lib/mpd/music/NAS\`"           >> ${SETUP}
if [ -e /var/lib/mpd/database ]&&[ "${MPDMUSIC}" == "/mnt/NAS" ]; then
	cp /var/lib/mpd/database ${BACKUP}/
	echo "if [ \"\${MPDMUSIC}\" == \"${MPDMUSIC}\" ]; then"       >> ${SETUP}
	echo "	if [ ! -e /var/lib/mpd/database.org ]; then"      >> ${SETUP}
	echo "		mv /var/lib/mpd/database /var/lib/mpd/database.org"                  >> ${SETUP}
	echo "	else"                                                                    >> ${SETUP}
	echo "		mv /var/lib/mpd/database /var/lib/mpd/database_\$(date +%Y%m%d%H%M)" >> ${SETUP}
	echo "	fi"                                               >> ${SETUP}
	echo "	cp \${BACKUP}/database /var/lib/mpd/database"     >> ${SETUP}
	echo "fi"                                                 >> ${SETUP}
fi

echo "systemctl restart mpd "                                 >> ${SETUP}
# ------------- Samba----- ----------------------------------------------
if [ -d /volumio ]; then
	cp /etc/samba/smb.conf ${BACKUP}/smb.conf.volumio
elif [ -d /usr/local/html/mpdweb ]; then
	cp /etc/samba/smb.conf ${BACKUP}/smb.conf.myset
elif [ -d /etc/samba/smb.conf ]; then
	cp /etc/samba/smb.conf ${BACKUP}/smb.conf.other
fi
echo "# Samba Set" >> ${SETUP}
echo "if [ -e /etc/samba/smb.conf ]; then"                       >> ${SETUP}
echo "	if [ -e /etc/samba/smb.conf.org ]; then"                 >> ${SETUP}
echo "		cp /etc/samba/smb.conf{,_\$(date +%Y%m%d%H%M%S)}"    >> ${SETUP}
echo "	else"                                                    >> ${SETUP}
echo "		cp /etc/samba/smb.conf /etc/samba/smb.conf.org"      >> ${SETUP}
echo "	fi"                                                      >> ${SETUP}
echo "	if [ -d /volumio ]&&[ -e \${BACKUP}/smb.conf.volumio]; then"         >> ${SETUP}
echo "		cp \${BACKUP}/smb.conf.volumio  /etc/samba/smb.conf"             >> ${SETUP}
echo "	elif [ -d /usr/local/html ]&&[ -e \${BACKUP}/smb.conf.myset ]; then" >> ${SETUP}
echo "		cp \${BACKUP}/smb.conf.myset /etc/samba/smb.conf"    >> ${SETUP}
echo "	elif [ -e \${BACKUP}/smb.conf.other ]; then"             >> ${SETUP}
echo "		cp \${BACKUP}/smb.conf.other /etc/samba/smb.conf"    >> ${SETUP}
echo "	fi"                                                      >> ${SETUP}
echo "	if [ -e /etc/init.d/samba ]; then"                       >> ${SETUP}
echo "		/etc/init.d/samba restart"                           >> ${SETUP}
echo "	elif [ -e /etc/init.d/smbd ]; then"                      >> ${SETUP}
echo "		/etc/init.d/smbd restart"                            >> ${SETUP}
echo "		if [ -e /etc/init.d/nmbd ]; then"                    >> ${SETUP}
echo "			/etc/init.d/nmbd restart"                        >> ${SETUP}
echo "		fi"                                                  >> ${SETUP}
echo "	else"                                                    >> ${SETUP}
echo "		systemctl restart smbd  nmbd 2>/dev/null"            >> ${SETUP}
echo "	fi"                                                      >> ${SETUP}
echo "fi"                                                        >> ${SETUP}

echo "if command -v mpc > /dev/null 2>&1; then"                  >> ${SETUP}
echo "	echo \"MPD D/B Update Start\""                           >> ${SETUP}
echo "	mpc update"                                              >> ${SETUP}
echo "else"                                                      >> ${SETUP}
echo "	echo \"Manually update mpd!!\""                          >> ${SETUP}
echo "fi"                                                        >> ${SETUP}
# ------------- Tool & I/F ----------------------------------------------
echo "# Tool I/F Set"  >> ${SETUP}

echo "if (which apt-get)||(which apt); then"                        >> ${SETUP}
echo "	if(which apt);then APTGET=apt; else APTGET=apt-get; fi"     >> ${SETUP}
echo "	echo \"\${APTGET} Update Start\""                           >> ${SETUP}
echo "	\${APTGET} update -y > /dev/null 2>&1"                      >> ${SETUP}
echo "	echo \"\${APTGET} Update End\""                             >> ${SETUP}
echo "fi"                                                           >> ${SETUP}
if (php -i | grep -Ei '^(gd)' | grep enabled);then
	echo "if (php -i | grep -Ei '^(gd)' | grep enabled);then"       >> ${SETUP}
	echo "	echo \"Enabled GD\""                                    >> ${SETUP}
	echo "else"                                                     >> ${SETUP}
	echo "	if (which apt)||(which apt-get); then"                  >> ${SETUP}
	echo "		echo \"GD install\""                                >> ${SETUP}
	echo "		\${APTGET} install -y php-gd > /dev/null 2>&1;"     >> ${SETUP}
	echo "	fi"                                                     >> ${SETUP}
	echo "fi"                                                       >> ${SETUP}
fi
if (php -i | grep -Ei '^(imagick)' | grep enabled);then
	echo "if [ -d /volumio ]; then echo \"imagick Volumio is installed manually\"; else"  >> ${SETUP}
	echo "	if (php -i | grep -Ei '^(imagick)' | grep enabled);then"  >> ${SETUP}
	echo "		echo \"Enabled imagick\""                             >> ${SETUP}
	echo "	else"                                                     >> ${SETUP}
	echo "		if (which apt)||(which apt-get); then"                >> ${SETUP}
	echo "			echo \"imagemagick install\""                     >> ${SETUP}
	echo "			\${APTGET} install -y imagemagick libmagickwand-dev php-imagick > /dev/null 2>&1;"  >> ${SETUP}
	echo "		fi"                                                   >> ${SETUP}
	echo "	fi"                                                       >> ${SETUP}
	echo "fi"                                                         >> ${SETUP}
fi

if [ -e /etc/init.d/upmpdmyset ]; then
	echo "Find upmpdmyset(UpMpdCli)"
	echo "if [ -e ./inst_tool/install_volumio_upmpdcli.sh ] ; then ./inst_tool/install_volumio_upmpdcli.sh; fi" >> ${SETUP}
fi

if [ -e /opt/RoonBridge/Bridge/RoonBridge.exe ]; then
	echo "Find RoonBridge"
	echo "if [ -e ./inst_tool/install_RoonBridge.sh ] ; then"     >> ${SETUP}
	echo "	echo \"RoonBridge Install Start\""                    >> ${SETUP}
	echo "	./inst_tool/install_RoonBridge.sh > /dev/null"        >> ${SETUP}
	echo "	echo \"RoonBridge Install End\""                      >> ${SETUP}
	echo "fi"                                                     >> ${SETUP}
fi

# ------------- Conf File  ----------------------------------------------
echo "echo \"upmpdcli.conf : friendlyname Search\""                             >> ${SETUP}
if [ -e /etc/upmpdcli.conf ]; then
	echo "Find upmpdcli.conf"
	cp /etc/upmpdcli.conf ${BACKUP}/upmpdcli.conf
	ONAME=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="friendlyname" {print $2}'  /etc/upmpdcli.conf`
	OHOST=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="mpdhost" {print $2}'       /etc/upmpdcli.conf`
	OPORT=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="mpdport" {print $2}'       /etc/upmpdcli.conf`
	OPASS=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="mpdpassword" {print $2}'   /etc/upmpdcli.conf`
	OQUSR=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="qobuzuser" {print $2}'     /etc/upmpdcli.conf`
	OQPAS=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="qobuzpass" {print $2}'     /etc/upmpdcli.conf`
	OQFID=`awk -F '[[:space:]]*=[[:space:]]*' '$1=="qobuzformatid" {print $2}' /etc/upmpdcli.conf`
	echo "CFICONF=/etc/upmpdcli.conf"                                    >> ${SETUP}
	if [ -n "$NAME" ] || [ -n "$OHOST" ] || [ -n "$OPORT" ] || [ -n "$OPASS" ] || [ -n "$OQUSR" ] || [ -n "$OQPAS" ] || [ -n "$OQFID" ]; then
		echo "ON=0"                                                      >> ${SETUP}
		echo "#--- Function backup_upmpdcli_conf() : Make Backup------#" >> ${SETUP}
		echo "backup_upmpdcli_conf() {"                                  >> ${SETUP}
		echo "  if [ \"\$ON\" == \"1\" ]; then"                          >> ${SETUP}
		echo "		return"                                              >> ${SETUP}
		echo "	fi"                                                      >> ${SETUP}
		echo "	ON=1"                                                    >> ${SETUP}
		echo "	if [ -e \$CFICONF.org ] ; then"                          >> ${SETUP}
		echo "		cp \${CFICONF}{,_\$(date +%Y%m%d%H%M%S)}"              >> ${SETUP}
		echo "	else"                                                    >> ${SETUP}
		echo "		cp \$CFICONF \$CFICONF.org"                          >> ${SETUP}
		echo "	fi"                                                      >> ${SETUP}
		echo "	}"                                                       >> ${SETUP}
		echo "#--- Function update_upmpdcli_item() : Set Value -------#" >> ${SETUP}
		echo "update_upmpdcli_item() {"                                  >> ${SETUP}
		echo "	local ITEM_NAME=\"\$1\" # 例: friendlyname, mpdhost..."   >> ${SETUP}
		echo "	local ITEM_VALUE=\"\$2\""                                 >> ${SETUP}
		echo "	local current_value"                                     >> ${SETUP}
		echo "	current_value=\$(awk -F '[[:space:]]*=[[:space:]]*' -v key=\"\$ITEM_NAME\" '\$1==key {print \$2}' \$CFICONF)" >> ${SETUP}
		echo "	if [ \"\$ITEM_VALUE\" != \"\$current_value\" ]; then"    >> ${SETUP}
		echo "		backup_upmpdcli_conf"                                >> ${SETUP}
		echo "	 	echo \"\$CFICONF $ITEM_NAME Replace\""               >> ${SETUP}
		echo "		if [ -n \"\$current_value\" ]; then"                 >> ${SETUP}
		echo "			if [ -z \"\$ITEM_VALUE\" ]; then"				 >> ${SETUP}
		echo "				sed -i \"s/^\\s*\$ITEM_NAME\\s*=.*/#&/\" \$CFICONF" >> ${SETUP}
		echo "			else"                                            >> ${SETUP}
		echo "				sed -i -e \"s/^\\(\$ITEM_NAME[[:space:]]*=[[:space:]]*\\).*/\\1\$ITEM_VALUE/\" \$CFICONF" >> ${SETUP}
		echo "			fi"                                              >> ${SETUP}
		echo "		else"                                                >> ${SETUP}
 		echo "			sed -i \"/^#\$ITEM_NAME[[:space:]]*=/a \$ITEM_NAME = \$ITEM_VALUE\" \$CFICONF" >> ${SETUP}
 		echo "		fi"                                                  >> ${SETUP}
 		echo "	fi"                                                      >> ${SETUP}
 		echo "	}"                                                       >> ${SETUP}
		echo "#--- Edit upmpdcli.conf --------------------------------#" >> ${SETUP}
		echo "if [ -e \$CFICONF ]; then"                                 >> ${SETUP}
		echo "	update_upmpdcli_item \"friendlyname\" \"$ONAME\""        >> ${SETUP}
		echo "	update_upmpdcli_item \"mpdhost\" \"$OHOST\""             >> ${SETUP}
		echo "	update_upmpdcli_item \"mpdport\" \"$OPORT\""             >> ${SETUP}
		echo "	update_upmpdcli_item \"mpdpassword\" \"$OPASS\""         >> ${SETUP}
		echo "	update_upmpdcli_item \"qobuzuser\" \"$OQUSR\""           >> ${SETUP}
		echo "	update_upmpdcli_item \"qobuzpass\" \"$OQPAS\""           >> ${SETUP}
		echo "	update_upmpdcli_item \"qobuzformatid\" \"$OQFID\""       >> ${SETUP}
		echo "	systemctl restart upmpdcli"                              >> ${SETUP}
		echo "	echo \"upmpdcli.conf,Please fix it manually!\""          >> ${SETUP}
		echo "fi"                                                        >> ${SETUP}
	fi
fi
echo "echo \"Restore End\""                                              >> ${SETUP}
tar -zcvf mpdweb_backup_set.tar.gz ${BACKUP}
rm -r -f ${BACKUP}/
echo "Backup End"
exit
