#!/bin/bash
# MPDWEB  & Tools,I/F Restore            Make: Mikio.Shiratori,2024.02.21
# user ;  suで実行 : Input:./mpdweb_backup_set.tar.gz

INSTDIR=`pwd`
TAR=`ls ${INSTDIR}/mpdweb_backup_set*.tar.gz 2> /dev/null`
BACKUP=mpdweb_backup
# Bacukup 展開
echo "Backup Deployment"
if [ -n "$TAR" ] ; then
	echo "$TAR setting Start"
else
	echo "No mpdweb__set{User}.tar.gz Put it here!!"
	exit
	fi
# ------------- install tool gz -----------------------------------------
if [ -e inst_tool.tar.gz ]; then
	tar -zxvf inst_tool.tar.gz
	chmod 0777 -R -f inst_tool
fi

# ------------- Backup gz -----------------------------------------------
echo ${TAR}
tar xzvf ${INSTDIR}/mpdweb_*.tar.gz
chmod 0777 ${BACKUP}
chmod 0755 ${BACKUP}/mpdweb_restore_child.sh
chmod 0666 ${BACKUP}/mpdweb_backup.tar.gz
chmod 0666 ${BACKUP}/mpd.conf
chmod 0666 ${BACKUP}/smb.conf*
if [ -e ./inst_tool/install_RoonBridge.sh ] ; then
	chmod 0755 ./inst_tool/install_RoonBridge.sh
fi
if [ -e ./inst_tool/install_volumio_upmpdcli.sh ] ; then
	chmod 0755 ./inst_tool/install_volumio_upmpdcli.sh
fi

# MPDWEB展開

tar xzvf ${BACKUP}/mpdweb_backup.tar.gz -C /
sync;sync;
# Tool&I/F再設定
${BACKUP}/mpdweb_restore_child.sh
echo "Page Caches Clear"
sh -c "sync; echo 1 > /proc/sys/vm/drop_caches"
sh -c "sync; echo 2 > /proc/sys/vm/drop_caches"
sh -c "sync; echo 3 > /proc/sys/vm/drop_caches"
exit
