#!/bin/bash
# install : moodeAudio
# PHP7.4

# install Mount Directory --------------------------------------------------
# NAS/music下にMusicData / playlistsをNASに設定化にしておく
echo "Mount Directory Configration"
mkdir /mnt/NAS/music
mkdir /mnt/playlists
chmod 0777 -R /mnt/NAS/music
chmod 0777 -R /mnt/playlists
chmod 0777 /var/lib/mpd/music

# install mpd music/playlist Directory -------------------------------------
mv /var/lib/mpd/playlists /var/lib/mpd/playlists.org
ln -s /mnt/playlists /var/lib/mpd/

# install html root  Directory ---------------------------------------------
# moodeaudioは/var/www/にインストールされている。
# - mpdwebは /var/www/htmlにインストール
# Web Document Root を/usr/local/htmlに作成
# - /usr/local/htmlに /var/www/htmlmpdweb をリンク
# - /usr/local/htmlに /var/lib/mpd/music Musicとしてリンク
# ※ /var/www/下のシンボリックリンクは消えてしまう対応
mkdir /var/www/html/
mkdir /var/www/html/mpdweb
chmod 0777 -R -f /var/www/html
mkdir /usr/local/html
chmod 0777 /usr/local/html
ln -s /var/www/html/mpdweb /usr/local/html/
ln -s /var/lib/mpd/music/ /usr/local/html/Music
#ln -s /var/lib/mpd/music/ /var/www/html/Music

# php Module Installl -------------------------------------------------------
echo "PHP Module Install"
apt-get update
apt-get install -y php php-cgi php-fpm
apt-get install -y php-xml php-mbstring

# samba share setting -------------------------------------------------------
echo "make Samba Configration"
SAMBACONF=/etc/samba/smb.conf
SAMBATMP=./smb.conf.add
SMBADD=`cat $SAMBACONF | grep "\[WWW]"`

if [ -n "$SMBADD" ] ; then
	echo "smb.conf share item not add"
else
	echo "smb.conf share item add start"
	cp $SAMBACONF $SAMBACONF.`date +%Y%m%d%H%M%S`
cat - << EOS > $SAMBATMP
[www]
comment = html Folder
path = /var/www/html/
read only = no
guest ok = yes
browseable = yes
EOS
	cat $SAMBACONF $SAMBATMP > $SAMBACONF.new
	mv $SAMBACONF.new $SAMBACONF
	chmod 0666 $SAMBACONF
	rm -f $SAMBATMP

	if [ -e /etc/init.d/smbd ]; then
		systemctl enable smbd
		/etc/init.d/smbd restart
		fi
	if [ -e /etc/init.d/nmbd ]; then
		systemctl enable nmbd
		/etc/init.d/nmbd restart
		fi
	echo "smb.conf share item add End"
fi

# nginx Setting -------------------------------------------------------------
echo "make nginx Configration"
# nginx sites default
PHPSOCK=`ls /run/php/php*.sock`
if [ -z "$PHPSOCK" ]; then
	PHPSOCK=`ls /var/run/php*.sock`
fi

service nginx stop

DEFFILE="/etc/nginx/sites-available/default"
AVAFILE="/etc/nginx/sites-available/mpdweb.conf"
ENAFILE="/etc/nginx/sites-enabled/mpdweb.conf"
NGINXOFILE="./mpdweb.conf";
echo "Start nginx Set default"
perl -sle '
if ($LS eq "") {
	print STDERR "nginx Set Error php*.sock - Not Found";
	exit(1);
	}
print "sites-available : ".$DFILE;

my @tmp = split(/\n/,$LS);		# /run/php/php7.4-fpm.sock /run/php/php-fpm.sock 複数見つかった
$LSSOCK=$tmp[0];				# 先頭を使用する

print "sites-available default Live nginx Soket: ".$LSSOCK;
print "sites-available default temp file : ".$OFILE;
open(my $IFP, "< ".$DFILE) or die("error :$!");		# Input File
open(my $OFP, ">$OFILE") or die "$!";				# Output File

my $update=0;
my $locphp=0;
while (my $line = <$IFP>){
	chomp($line);
	my $l=$line;
	$l =~ s/^\s+//;$l =~ s/^\t+//;
	if (($l=~ /^listen/) and ($line=~ /default_server/)) {	# listen Portを変更する
		$line=~ s/80/88/;
		print "$line";
		$update=1;
		}
	if (($l=~ /^index/) and ($line=~ /index.html/)) {		# indexにphpを追加
		if (($line=~ /index.php/)) { }
		else {
			 $line=~ s/index.html/index.html index.php/;
			 print "$line";
			 $update=1;
			 }
		}
	if ($l=~ /^root /) {	# rootを変更 root /var/www/html→root /usr/local/html;
		$line="\troot /usr/local/html;";
		print "$line";
		$update=1;
		}
	if (($line=~ /location/)and ($line=~ /\\.php\$/)) {		# location \.php$を有効にする
		$locphp=1;
		}
	if ($locphp ==1) {
		if($line=~ /fastcgi_pass/) {			# fastcgi_pass unix:置換
			if($line=~ /unix:/) {
				my @ary = split(/unix:/,$line);
				if ((my $n=@ary) > 0) {
					my @word = split(/;/,$ary[1]);		# unix:/var/run/php?.sockを置換
					$line=~ s/$word[0]/$LSSOCK/;
					$line =~ s/#//;						# コメント削除

					$line=$line."\n\t\tfastcgi_buffers 8 32K;\t\t# Add MPDWEB default 8 4k|8k\n";
					$line=$line."\t\tfastcgi_buffer_size 32k;\t# Add MPDWEB dedault 4k|8k\n";

				  	print "$line";
					$update=1;
					}
				}
			 }
		else {
			 $line =~ s/#//;							# コメント削除
			 print "$line";
			 $update=1;
			 my $l=$line;
			 $l=$line;
			 $l =~ s/^\s+//;$l =~ s/^\t+//;
			 if ($l=~ /^}/){
				 $locphp=0;
				 }
			 }
		}
	print $OFP $line;
	}
close($OFP);
close($IFP);
if($update eq 0) {
	print STDERR "nginx Set Error Update Data Not Found";
	exit(1);
	}
' -- -LS="$PHPSOCK" -OFILE="$NGINXOFILE" -DFILE="$DEFFILE" 2> ./result
echo "End nginx Set"
if [ ! -s ./result ]; then
	echo "Make nginx default Normal End"
else
	cat ./result
	echo "Abend nginx Set"
	exit
fi

cp $NGINXOFILE $AVAFILE
chmod 0666 $AVAFILE
ln -s $AVAFILE $ENAFILE
rm -f $NGINXOFILE
rm -f ./result

# nginx init.d restart
service nginx restart
echo "Moode install End"
# MoodeAudio Setting End ----------------------------------------------------
