#!/bin/bash
# install : mpdweb
#
# WEBTOPを設定する場合下記コメントを有効にする
# WEBTOP=/var/www/html
WEBTOP=
# WEBTOPが未指定の場合，/var/www/html , /var/www いずれかにInstall
if [ -z $WEBTOP ]; then
	if [ -e /var/www/html ]; then
		WEBTOP=/var/www/html
	else
		if [ -e /var/www ]; then
		    WEBTOP=/var/www
		else
			echo "Install Directory Invaliud"
		fi
	fi
fi
echo "Install Directory : $WEBTOP"

INSTDIR=`pwd`
cd ${WEBTOP}
mkdir ${WEBTOP}/mpdweb
cd ${WEBTOP}/mpdweb

TAR=`ls ${INSTDIR}/mpdweb_*.tar.gz 2> /dev/null`
if [ -n "$TAR" ] ; then
	echo "$TAR setting Start"
else
	echo "No mpdweb_{vartion}.tar.gz Put it here!!"
	exit
	fi

tar xzvf ${INSTDIR}/mpdweb_*.tar.gz
if [ -e ${WEBTOP}/mpdweb/index.php ]; then
	echo "No Make mpdweb/index.php"
else
	ln -s ${WEBTOP}/mpdweb/mpdweb.php ${WEBTOP}/mpdweb/index.php
fi

if getent passwd http > /dev/null; then
    WEBUSER=http
else
    WEBUSER=www-data
fi
if getent group http > /dev/null; then
    WEBGROUP=http
else
    WEBGROUP=www-data
fi
echo "WebUser:$WEBUSER:$WEBGROUP"

chown -R -f "$WEBUSER:$WEBGROUP" ${WEBTOP}/mpdweb

find ${WEBTOP}/mpdweb -type d -exec chmod 0777 {} \;
find ${WEBTOP}/mpdweb -type f -exec chmod 0666 {} \;

chmod -R -f 0777 ${WEBTOP}/mpdweb/init.d
chmod -R -f 0777 ${WEBTOP}/mpdweb/mount.d
chmod -R -f 0777 ${WEBTOP}/mpdweb/start.d
chmod -R -f 0777 ${WEBTOP}/mpdweb/shell
chmod -R -f 0777 ${WEBTOP}/mpdweb/setting

if [ -e /etc/init.d/mpdtask ]; then
	echo "init.d mpdtask already exists"
elif [ -d /etc/init.d ]; then
	ln -s ${WEBTOP}/mpdweb/init.d/mpdtask /etc/init.d/mpdtask
	systemctl enable mpdtask
	/etc/init.d/mpdtask restart
elif systemctl is-enabled --quiet mpdtask.service; then
	echo "service mpdtask already exists"
else
	systemctl enable ${WEBTOP}/mpdweb/service/mpdtask.service
	systemctl restart mpdtask.service
fi

if [ -e /etc/init.d/mpdstartup ]; then
	echo "init.d mpdstartup already exists"
elif [ -d /etc/init.d ]; then
	ln -s ${WEBTOP}/mpdweb/init.d/mpdstartup /etc/init.d/mpdstartup
	systemctl enable mpdstartup
	/etc/init.d/mpdtask restart
elif systemctl is-enabled --quiet mpdstartup.service; then
	echo "service mpdstartup already exists"
else
	systemctl enable ${WEBTOP}/mpdweb/service/mpdstartup.service
	systemctl restart mpdstartup.service
fi

if [ -e /etc/init.d/mpdmount ]; then
	echo "init.d mpdmount already exists"
elif [ -d /etc/init.d ]; then
	ln -s ${WEBTOP}/mpdweb/init.d/mpdmount /etc/init.d/mpdmount
	systemctl enable mpdmount
	/etc/init.d/mpdmount restart
elif systemctl is-enabled --quiet mpdmount.service; then
	echo "service mpdmount already exists"
else
	systemctl enable ${WEBTOP}/mpdweb/service/mpdmount.service
	systemctl restart mpdmount.service
fi

sh -c "sync; echo 1 > /proc/sys/vm/drop_caches"
sh -c "sync; echo 2 > /proc/sys/vm/drop_caches"
sh -c "sync; echo 3 > /proc/sys/vm/drop_caches"

echo "Install End"

