#!/bin/bash
# install : volumi3
# PHP7.3

# install vim ----------------------------------------------------------------
echo "install vim"
apt-get update
apt-get install -y vim

# install link Playlist ------------------------------------------------------
touch /data/ignoresystemcheck
echo "make volumio playlist Hard link"
ln -s /data/playlist "/data/Playlist(Volumio)"
ln -s /var/lib/mpd/music /volumio/http/www/Music

if [ -L /mnt/playlists ]; then
	echo "Playlist Next..."
else
	echo "make playlist Hard link"
	mkdir /mnt/playlists
	chmod 0777 /mnt/playlists
	mv /var/lib/mpd/playlists /var/lib/mpd/playlists.org
	ln -s /mnt/playlists /var/lib/mpd/playlists
fi

# nginx php install ---------------------------------------------------------

echo "apt Net search libapache2-mod-php7 wait a minute..."
PHP7=`apt-cache search libapache2-mod-php7*`
PHPVAR="PHP5"
if [[ "$PHP7" == *libapache2-mod-php7* ]]; then
	PHPVAR="PHP7"
else
	if [[ "$PHP7" == *libapache2-mod-php5* ]]; then
		PHPVAR="PHP5"
	else
		echo "apt Net search libapache2-mod-php5 wait a minute..."
		PHP5=`apt-cache search libapache2-mod-php5*`
		if [[ "$PHP5" == *libapache2-mod-php5* ]]; then
			PHPVAR="PHP5"
		else
			echo "Not PHP Version PHP5 or PHP7"
			exit
		fi
	fi
fi

if [ "PHP7" == "$PHPVAR" ]; then
	echo "Install : nginx php7"
	apt-get update
	apt-get install -y nginx
	apt-get install -y php php-cgi php-fpm
	apt-get install -y php-xml php-mbstring
else 
	echo "Install : nginx php5"
	apt-get update
	apt-get install -y nginx
	apt-get install -y php5 php5-cgi php5-fpm
	fi

# samba share install -------------------------------------------------------
echo "make Album Art directory Hard Link"
ln -s /var/lib/mpd/music /var/www/html/Music
chmod 0777 -R -f /var/www/html

# samba share setting -------------------------------------------------------
echo "make Samba Configration"
SAMBACONF=/etc/samba/smb.conf
SAMBATMP=./smb.conf.add
SMBADD=`cat $SAMBACONF | grep "\[volmio Playlist\]"`

if [ -n "$SMBADD" ] ; then
	echo "smb.conf share item not add"
else
	echo "smb.conf share item add start"
	cp $SAMBACONF $SAMBACONF.`date +%Y%m%d%H%M%S`
cat - << EOS > $SAMBATMP

[volmio Playlist]
        comment = Volumio Playlis Folder
        path = /data/Playlist(Volumio)
        read only = no
        guest ok = yes

[mpd Playlist]
        comment = mpd Playlis Folder
        path = /var/lib/mpd/playlists
        read only = no
        guest ok = yes

[Volumio html]
        comment = Volumio html Folder
        path = /var/www/html
        read only = no
        guest ok = yes

EOS

	cat $SAMBACONF $SAMBATMP > $SAMBACONF.new
	mv $SAMBACONF.new $SAMBACONF
	chmod 0666 $SAMBACONF
	rm -f $SAMBATMP

	SAMB="smbd"
	if [ -e /etc/init.d/samba ]; then
		SAMB="samba"
		fi
	/etc/init.d/$SAMB restart
	echo "smb.conf share item add End"
fi

# nginx Setting -------------------------------------------------------------
echo "make nginx Configration"
# nginx sites default
PHPSOCK=`ls /run/php/php*.sock`
if [ -z "$PHPSOCK" ]; then
	PHPSOCK=`ls /var/run/php*.sock`
fi

service nginx stop
systemctl disable nginx

DEFFILE="/etc/nginx/sites-available/default"
NGINXOFILE="./default";
echo "Start nginx Set default"
perl -sle '
if ($LS eq "") {
	print STDERR "nginx Set Error php*.sock - Not Found";
	exit(1);
	}
print "sites-available : ".$DFILE;
print "sites-available default Live nginx Soket: ".$LS;
print "sites-available default temp file : ".$OFILE;
open(my $IFP, "< ".$DFILE) or die("error :$!");		# Input File
open(my $OFP, ">$OFILE") or die "$!";				# Output File

my $update=0;
my $locphp=0;
while (my $line = <$IFP>){
	chomp($line);
	my $l=$line;
	$l =~ s/^\s+//;$l =~ s/^\t+//;
	if (($l=~ /^listen/) and ($line=~ /default_server/)) {	# listen PortύX
		$line=~ s/80/88/;
		print "$line";
		$update=1;
		}
	if (($l=~ /^index/) and ($line=~ /index.html/)) {		# indexphpǉ
		if (($line=~ /index.php/)) { }
		else {
			 $line=~ s/index.html/index.html index.php/;
			 print "$line";
			 $update=1;
			 }
		}
	if (($line=~ /location/)and ($line=~ /\\.php\$/)) {		# location \.php$Lɂ
		$locphp=1;
		}
	if ($locphp ==1) {
		if($line=~ /fastcgi_pass/) {			# fastcgi_pass unix:u
			if($line=~ /unix:/) {
				my @ary = split(/unix:/,$line);
				if ((my $n=@ary) > 0) {
					my @word = split(/;/,$ary[1]);		# unix:/var/run/php?.socku
					$line=~ s/$word[0]/$LS/;
					$line =~ s/#//;						# Rg폜
				  	print "$line";
					$update=1;
					}
				}
			 }
		else {
			 $line =~ s/#//;							# Rg폜
			 print "$line";
			 $update=1;
			 my $l=$line;
			 $l=$line;
			 $l =~ s/^\s+//;$l =~ s/^\t+//;
			 if ($l=~ /^}/){
				 $locphp=0;
				 }
			 }
		}
	print $OFP $line;
	}
close($OFP);
close($IFP);
if($update eq 0) {
	print STDERR "nginx Set Error Update Data Not Found";
	exit(1);
	}
' -- -LS="$PHPSOCK" -OFILE="$NGINXOFILE" -DFILE="$DEFFILE" 2> ./result
echo "End nginx Set"
if [ ! -s ./result ]; then
	echo "Make nginx default Normal End"
else
	cat ./result
	echo "Abend nginx Set"
	exit
fi

cp $DEFFILE $DEFFILE.`date +%Y%m%d%H%M%S`
cp $NGINXOFILE $DEFFILE
chmod 0666 $DEFFILE
rm -f $NGINXOFILE
rm -f ./result

# nginx init.d Set
NGINXRUN="/etc/init.d/nginx"
NGINXNEW="./nginx_rc";
echo "Start init.d/nginx Set"

perl -sle '
print "Service nginx file : ".$RUNFILE;
print "Service nginx New  file : ".$OFILE;
open(my $IFP, "< ".$RUNFILE) or die("error :$!");		# Input File
open(my $OFP, ">$OFILE") or die "$!";					# Output File

my $update=0;
my $locphp=0;
while (my $line = <$IFP>){
	chomp($line);

	my $l=$line;
	$l =~ s/^\s+//;$l =~ s/^\t+//;
	if (($l=~ /^#/) and ($line=~ /Provides/)and ($line=~ /nginx/)) {	# Provides ύX
		$line=~ s/nginx/nginx_rc/;
		print "$line";
		$update=1;
		}
	if ($l=~ /^DESC=nginx/) {							# /var/log/nginx ǉ邷
		$line=$line."\n"."\necho `date` > /tmp/nginx.log\nmkdir /var/log/nginx >> /tmp/nginx.log 2>> /tmp/nginx.log\n";
		print "$line";
		$update=1;
		}
	print $OFP $line;
	}
close($OFP);
close($IFP);
if($update eq 0) {
	print STDERR "init.d nginx Set Error Update Data Not Found";
	exit(1);
	}
' -- -LS="$PHPSOCK" -OFILE="$NGINXNEW" -RUNFILE="$NGINXRUN" 2> ./result
echo "End  init.d/nginx Set"
if [ ! -s ./result ]; then
	echo "Make nginx init.d Normal End"
else
	cat ./result
	echo "Abend  init.d/nginx Set"
	exit
fi

cp $NGINXNEW /etc/init.d/nginx_rc
chmod 0755 /etc/init.d/nginx_rc

systemctl enable nginx_rc
service nginx_rc restart

rm -f $NGINXNEW
rm -f ./result
