#!/bin/sh
# Install networkaudiod Install
# Used : ARM

ARCH=$(uname -m)

case "$ARCH" in
	armv7l)
		echo "This system is running on AArch32 architecture."
		ARM=armhf
		;;
	aarch64)
		echo "This system is running on AArch64 architecture."
		ARM=arm64
		;;
	armel)
		echo "This system is running on armel architecture."
		ARM=armhl
		;;
	armv6l|armv5tel|armv4tl|armv4l)
		echo "This system is running on armel architecture (older version)."
		ARM=armhl
		;;
	arm*)
		echo "This system is running on armeh architecture."
		ARM=armhl
		;;
	*)
		echo "Unknown architecture."
		exit 1
		;;
esac
INSTDIR=`pwd`
echo "Instrll Type ${ARM}"
TAR=`ls networkaudiod_*_${ARM}.deb 2> /dev/null`
if [ -n "${TAR}" ] ; then
	echo "$TAR setting Start"
else
	echo "Install Error,networkaudiod_*_${ARM}.deb Put it here!!"
	exit 1
fi

dpkg -i ${TAR}

systemctl start networkaudiod
systemctl enable networkaudiod
