#!/bin/sh
# Install RoonBridge Install
# Used : ARM

ARCH=$(uname -m)

case "$ARCH" in
	armv7l)
		echo "This system is running on AArch32 architecture."
		ARM=armv7hf
		;;
	aarch64)
		echo "This system is running on AArch64 architecture."
		ARM=armv8
		;;
	armel)
		echo "This system is running on armel architecture."
		;;
	armv6l|armv5tel|armv4tl|armv4l)
		echo "This system is running on armel architecture (older version)."
		echo "This shell doesn't take this into account"
		exit 1
		;;
	arm*)
		echo "This system is running on armeh architecture."
		echo "This shell doesn't take this into account"
		exit 1
		;;
	*)
		echo "Unknown architecture."
		exit 1
		;;
esac
INSTDIR=`pwd`
echo "Install Type:${ARM}"
curl -O https://download.roonlabs.net/builds/roonbridge-installer-linux${ARM}.sh

if [ -e "roonbridge-installer-linux${ARM}.sh" ] ; then
	echo "roonbridge-installer-linux${ARM}.sh setting Start"
else
	echo "roonbridge-installer-linux${ARM}.sh Not Download,shell stop! "
	exit
fi

if command -v bzip2 >/dev/null 2>&1; then
  echo "bzip2 OK"
else
	apt-get install -y bzip2
fi
chmod +x ./roonbridge-installer-linux${ARM}.sh
./roonbridge-installer-linux${ARM}.sh << EOS
y
EOS
systemctl enable roonbridge
systemctl restart roonbridge
