<?php
/*******************************************************************************
	ブラウザから起動
	  起動方法 http://{host}/mpddirettamp.php?path={Path}
	FrameのClose Buttonを表示する場合
	  起動方法 http://{host}/mpddirettamp.php?frame=on&path={Path}
	path:Directoryまたは，File Path
	     %DOCROOT%が指定された場合，設定:MPD_DOCROOTの値に置換する (mpddiretta_config.php:$MPD_DOCROOT)
	起動が遅いのでBodyDisplay:noneにするだけにする
  ----------------------------------------------------------------------------
	設定ファイル : mpddiretta_config.php
	 ./settingがある場合，{SelfDirectory}/setting/mpddiretta_config.php
	          がない場合，./setting/mpddiretta_config.php  ./:(本モジュールと同じPath)
  ----------------------------------------------------------------------------
  Install mpddirettamp.php MemoryPlayerがArchLinux用なのでArchを参考
   実行環境 nginx , apache2 , php
	# pacman -Syu
	# pacman -S nginx
	# systemctl start nginx
	# systemctl enable nginx

	# pacman -S php php-fpm
	# systemctl start php-fpm
	# systemctl enable php-fpm
	# vi /etc/nginx/nginx.conf
        location / {
            root   /var/www/html;     <---- 変更
            index  index.html index.htmi index.php; <---- index.phpを追加
        }
        location ~ \.php$ {           <---- phpの設定
        #   root           html;
            fastcgi_pass   unix:/run/php-fpm/php-fpm.sock;
            fastcgi_index  index.php;
            fastcgi_param  SCRIPT_FILENAME  /var/www/html$fastcgi_script_name;
            include        fastcgi_params;
        }
	# vi fastcgi_params
	//////////$SERVER["DOCUMENT_ROOT"] が正しくないので下記を設定 ///////////
	fastcgi_param  DOCUMENT_ROOT      /var/www/html;
	# mkdir /var/www
	# mkdir /var/www/html
	# chown -R http:http /var/www/html
	# systemctl restart nginx
	# echo "<?php phpinfo(); ?>" > /var/www/html/phpinfo.php
	ブラウザで確認

	Nginx のパフォーマンスを向上
	# vi /etc/nginx/nginx.conf の該当部分を編集
	sendfile on;
	gzip on;
*******************************************************************************/
//ini_set('display_errors',1);				// エラー表示設定
$MY_VERDION="V0.7 (31.07.2025)";

/*******************************************************************************
  Install MemoryPlayController : MemoryPlayControllerSDK_{Version}.tar.zst 内の「memo.txt」参照
	/usrか/homeに作成すると本PHPでFindする。
	$ tar xvf MemoryPlayControllerSDK_{Version}.tar.zst
	$ cd MemoryPlayControllerSDK
	$ rm -rf flac
   FlacLibraryのInstall (MemoryPlayがTagを使用するためと思われる)
	$ git clone https://github.com/xiph/flac.git
   または
	$ wget https://ftp.osuosl.org/pub/xiph/releases/flac/flac-1.4.3.tar.xz
	$ tar xvf ../../flac-1.4.3.tar.xz 
   FlacLibraryコンパイル
    $ cd flac
    $ ./configure --host=$HOST --disable-ogg --enable-static
	# make
	# cd ..
   MemoryPlayHostのコンパイル
	make ARCH_NAME={x64-linux-14} Targetにより指定

  Install MemoryPlayHostLinux
	$ tar xvf MemoryPlayHostLinux_{Version}.tar.zst
	$ cd MemoryPlay
	手動セットアップ
	$ vi diretta_memoryplay_host.service
	[Unit]
	ConditionPathExists={InstallPath} # 例)/home/share/MemoryPlay
	[Service]
	ExecStart={InstallSErvcieModule}  #: 例)/home/share/MemoryPlay/MemoryPlayHostLinux

	# ln -s MemoryPlayHost_gcc14_x64_v1 MemoryPlayHostLinux  # ExecStartのModule名に合わせる
	# systemctl enable diretta_memoryplay_host.service
	# systemctl start diretta_memoryplay_host.service

  ※mpddirettamp.phpとMemoryPlayControllerは同じPCに設定 
    MemoryPlayHostLinuxは複数PCに設定可
*******************************************************************************/

// Config File Path : DispConfig()/PostMakeConfig()で作成
$MPC_DIR = __DIR__ . '/setting';
if(file_exists($MPC_DIR)){									// ./settingがあれば使用する
	 $MPC_CONFIGPATH = $MPC_DIR.'/mpddiretta_config.php';	// 設定FilePathを ./setting下にする
	 }
else {
	 $MPC_CONFIGPATH = __DIR__ . '/mpddiretta_config.php';	// ./settingがなければSourceと同じディレクトリを使用する
	 }
/*******************************************************************************
  外部定義($MPC_CONFIGPATH)
	Server設定は，Post時反映される。
	 $SEL_HOMEDIR="/mnt/NAS/music/";					// Top Directory
	 $MPC_PATH="/home/share/MemoryPlayControllerSDK/";	// MemoryPlayController Directory
	 $MPC_APPNAME="MemoryPlayController";				// make時の名称
	Client設定は，JSでPost「Function:」で実行し反映する。
	 $MPC_MONITOR="on";	(Client:Jsで使用				// Monitore EventLoop on/off
  を設定する。
	 $MPC_APPLIで結合して使用 : $MPC_PATH."/".$MPC_APPNAME 最終桁 "/" の有無は自由

  $MPC_MONITORの動作(HostがLocalで動作時有効)
  Play時のタイマー
    mpNowMusicWait: 2秒 /  mpNowMusicReGet: 30秒 -> Client側でmpNowMusicWait: 2秒Waitし mpNowMusicReGet:30秒でMemoryPlayから現在の情報をGet
  Disable時(Stop)のタイマー
    mpStatusWait  :60秒 /  mpStatusReGet  :120秒 -> Client側でmpStatusWaitWait:60秒Wait(同端末での情報はGEｔ)mpStatusReGet:120秒でMemoryPlayから現在の情報をGet
  「Mon」：on : タイマー監視を行う
         ：off: タイマー監視はしない(最新化は手動のみ)
*******************************************************************************/
if(file_exists($MPC_CONFIGPATH)) {
	 require_once($MPC_CONFIGPATH);
	 }
else {
	 $MPC_PATH="/home/share/MemoryPlayControllerSDK/";	// MemoryPlayControllerのDirectory Path
	 $result = `find /home -name MemoryPlayController;find /usr -name MemoryPlayController`;
	 if(($result)&&($result!=="")) {
		 $MPC_PATH=dirname($result);					// Mpd Session id Library
		 }
	 $MPC_APPNAME="MemoryPlayController";				// MemoryPlayControllerのFile Name
	 $MPC_MONITOR="on";									// Monitore EventLoop on/off

	 $SEL_HOMEDIR="/mnt/NAS/music/";					// Directory 選択のTop Path 未設定時 「/」から検索
	 if(!is_dir($SEL_HOMEDIR)) {
		 $SEL_HOMEDIR="/";
		 }
	 $MPD_DOCROOT="/mnt/";					// Directory 選択のTop Path 未設定時 「/」から検索
	 if(!is_dir($MPD_DOCROOT)) {
		 $MPD_DOCROOT="/";
		 }
	 }
// DirettaMemoryPlayによるので設定としない
$SEL_EXTENS="wav;flac;dsf;aif";							// 有効となる拡張子
$MPC_SEEKINIT=60;										// MemoryPlay Seek初期値
// MemoryPlayController実行設定
$MPC_EXECSEC=4;											// MemoryPlay実行Sec(PlayStatusをGetする秒数)
$MPC_CORRECTSEC=2;										// MemoryPlayから取得時間の補正
$MPC_ARY_STS=array("disconnect","play","pause");		// Status種類:Serverからを小文字で設定(PostMPMusicPointで取得時チェック)
/*******************************************************************************
  Host      : MemoryPlayHostを選択 : 他PCのMemoryPlayHostを反映させたいとき「Host」をクリック
  Target    : MemoryPlayHostのPlayDeviceを選択。他Diretta Targetを反映させたいとき「Host」をクリック

  Search    : MemoryPlayしたいMusicFileを選択 Directory(1個)/File(1File)を選択。TopDirectoryは設定できる。
  Upload    : 選択したMusicFileをMemoryPlayHostにUpload

  Connect   : Play。選択されている，Host&TargetをDirettaに接続して再生 (Play時にクリックすると停止するMemoryPlayのままの使用)
  Seek      : 指定秒数早送り(隣の数値が秒数)
 (xx:60)    : 早送り秒数(トグルで設置値を変更)
  Disconnect: Play。選択されている，Host&Targetを切断し再生を停止

  Mon       : タイマー監視を行うか停止するかをトグル (HostがLocalで動作時有効)
  Status    : 情報を最新化する。 Host/Target 現在のPlay状況などを強制的に取得
  Index     : PlaySequence クリックするとPlay位置の変更
  :         : MemoryPlayHostのModule，TopDirectoryを指定
*******************************************************************************/

/*** テスト用定義 *************************************************************/
// Test Modeユーザroot 以外は起動してもPlayしない
$MP_PATH="";		// 未設定時，Taskは systemctl enable diretta_memoryplay_host.serviceで行う
$MP_APPNAME="";		// $MP_PATH=と合わせて未設定時にしておく
//$MP_PATH="/home/share/MemoryPlay/";
//$MP_APPNAME="MemoryPlayHost_gcc14_x64_v1";
$MP_SERV=rtrim($MP_PATH,"/")."/".trim($MP_APPNAME,"/");
$MP_EXEC="echo '{password}' | sudo -S -u root ".$MP_SERV;
$MP_BASE="MemoryPlayHost";
$MPC_MONITOR=strtolower($MPC_MONITOR);
/* ----------------------------------------------------------------------------
	Grobal変数 $MPC_PATH/$MPC_APPNAMEを連結して MemoryPlayController起動Path
 ---------------------------------------------------------------------------- */
$MPC_APPLI=rtrim($MPC_PATH,"/")."/".trim($MPC_APPNAME,"/");
/* ----------------------------------------------------------------------------
  MemoryPlayController I/F
	MemoryPlayController -c list : Host List
	  {Host}
	MemoryPlayController -c target {Host}
	  {Target}
	MemoryPlayController -c upload {Host} {MusicFile/Directory}
	MemoryPlayController -c connect {Host} {Target}
	MemoryPlayController -c status {Host}
	 {Status}
	MemoryPlayController -c tag {Host}
	 {UpLoad File TAG}
	MemoryPlayController -c seek {Host} {Sec}
	MemoryPlayController -c seektag {No}
	MemoryPlayController -c quit {Host}
  Loopback Device時のみ有効
	MemoryPlayController
	 GetMessage LastTime=?? Tag=??
 ---------------------------------------------------------------------------- */

/*******************************************************************************
	Post Process & Function
*******************************************************************************/
if (isset($_POST['p'])) {
	if($_POST['p']=="getdir") {				// Get Directory BOX
		 PostGetdir();
		 }
	if($_POST['p']=="gethost") {			// Get MemoryPlay Host
		 PostGetMPHost();
		 }
	if($_POST['p']=="upload") {				// Directory,File upload
		 PostUpload();
		 }
	if($_POST['p']=="status") {				// Status & TAG List
		 PostMPStatus();
		 }
	if($_POST['p']=="connect") {			// Connect
		 PostMPConnect();
		 }

	if($_POST['p']=="seektag") {			// Seek Tag
		 PostMPSeekTag();
		 }
	if($_POST['p']=="disconnect") {			// Disconnect Quit
		 PostMPDisconnect();
		 }
	if($_POST['p']=="seek") {				// Seek
		 PostMPSeek();
		 }
	if($_POST['p']=="mpstart") {			// Seek
		 PostMPStart();
		 }
	if($_POST['p']=="musicpoint") {			// Seek
		 PostMPMusicPoint();
		 }
	if($_POST['p']=="makeconfig") {			// Make Configuratuin
		 PostMakeConfig();
		 }
	exit;
	}

/* -----------------------------------------------------------------------------
	PostGetdir() : Make Directory List
	$_POST dir={Path}
----------------------------------------------------------------------------- */
function PostGetdir() {
	global $SEL_HOMEDIR,$SEL_EXTENS;

	$dirhome=rtrim($SEL_HOMEDIR,"/")."/";
	if((isset($_POST["dir"]))&&($_POST["dir"]=="")||(!isset($_POST["dir"]))) {
		 $target=$dirhome;
//		 $target=str_replace("%20"," ",$target);		// Spaceの確認用
		 }
	else {
		 if (is_file($_POST["dir"])) {				// Fileの場合,Directoryを分離
			  $target=dirname($_POST["dir"]);
//			  $target=str_replace("%20"," ",$target);	// Spaceの確認用
			  }
		 else {
			  $target=$_POST["dir"];
//			  $target=str_replace("%20"," ",$target);	// Spaceの確認用
			  }
		 }
	$flag_exc="0";$str_exc="";
	if((isset($_POST["exc"]))&&($_POST["exc"]=="off")) {
		$flag_exc="1";
		$str_exc="+'&exc=off'";
		}
//print "dir[".$_POST["dir"]."]\n";
	$exary=explode(";",$SEL_EXTENS);			// Extension Array
	$safeTarget = str_replace(["[", "]", "'"], ["\\[", "\\]", "\\'"], rtrim($target, "/"));
	$list = glob($safeTarget . '/*');			// Directory/File List

	$dirlist=array();
	foreach($list as $key => $val) {
		$str="1";
   		if (is_file($val)) {	// Key:1{Path}:Directory / Key:2{Path}:File
			$extension = pathinfo($val,PATHINFO_EXTENSION);
			if ((!in_array($extension,$exary))&&($flag_exc == "0")) {
				continue;
				}
			$str="2";
 			}
		$skey=mb_strtolower($val);
		$dirlist[$str.$skey]=$val;
		}
	ksort($dirlist);
/*
	Directory Common Select Box
	idEditDir : 選択Pathを表示
	idEditFile: FileをSelect時Fileがセットされる。(Directory選択と区別のため)
*/
	print "idEditDirSel:";
	print '<div class="box EditDirBox scrbar" id=idEditDirSel style="position:absolute;top:73px;left:10px;width:440px;height:218px;">';	// Combo:WebRoot
	print '<table border="0" cellpadding="0" frame=void class=EditDirBoxTb style="padding: 4px 0 0 4px;display:block;">';
	$post='var dir=document.getElementById(\'idEditDir\').textContent;';
	$post=$post.'dir=encodeURIComponent(dir);';										// URLEncoder
	$post=$post.'RequestByPost(POSTMOD,\'p=getdir&dir=\'+dir'.$str_exc.');';		// Post String
	if ((($target !== "")&&($target !== "/"))&&( rtrim($target,"/") !== rtrim($dirhome,"/")  )) {
		$ary=explode("/",rtrim(trim($target,"/"),"/"));								// Return, Directorry
		unset($ary[count($ary)-1]);
		$target_dir="/".implode ("/",$ary);
		$select = 'document.getElementById(\'idEditDir\').textContent=\'' . addslashes($target_dir) . '\';';
		$select =$select.$post;
		print '<tr><td onclick="'.$select.'" class=EditDirBoxDt style="width:440px;">';
		if ($target_dir !=="") { $str='&nbsp;['.$target_dir.']'; } else { $str=""; }
		print '..'.$str;
		print '</td></tr>';
		}
	foreach ($dirlist as $key => $val) {
		$ary=explode("/",$val);
		$target_dir=$ary[count($ary)-1];
		$style="";
		if($key[0]=="1") {
			 $str=(rtrim($target,'/')).'/'.(trim($target_dir,'/'));
			 $str=str_replace("'","\\'",$str);
			 $select ='document.getElementById(\'idEditDir\').textContent=\''.$str.'\';';		// Directory Combo Select Event
			 $select =$select.'document.getElementById(\'idEditFile\').textContent=\'\';';		// Directory - File Combo Select Event
			 $select =$select.$post;
			 $class="EditDirBoxDt";
			 if($sel==$target_dir) {
				$style="background-color:#00bfff;color:#000000;";
				}
			 }
		else {
			 $str=str_replace("'","\\'",$val);
			 $select ='document.getElementById(\'idEditDir\').textContent=\''.$str.'\';';		// Directory - File Combo Select Event
			 $select =$select.'document.getElementById(\'idEditFile\').textContent=\''.(htmlspecialchars($target_dir)).'\';';	// Fileを選択時File Set
			 $class="EditDirBoxChd";
			 }
		print '<tr><td onclick="'.$select.';" class='.$class.' style="width:440px;'.$style.'">';
		print htmlspecialchars($target_dir);
		print '</td></tr>';
		}
	print '</table>';
	print "</dev>\n";
	}

/* -----------------------------------------------------------------------------
	PostGetMPHost() : Get MemoryPlay Host
----------------------------------------------------------------------------- */
function PostGetMPHost() {
	global $MakeSelectBoxJS;

	if(isset($_POST["host"])) {
		 $host=$_POST["host"];
		 print "PostGetMPHost Start Host[".$host."]\n";
		 print "idHostBox:";
		 $ret=DispMemoryHost($host);
		 }
	else {
		 print "PostGetMPHost Start\n";
		 print "idHostBox:";			// Post時 id
		 $host=DispMemoryHost();
		 }
	print "\n";

	print "idTagBox:";					// Hostに合ったTAG List
	DispMHStatus($host);
	print "\n";

	if(is_array($MakeSelectBoxJS)){		// SelectBoxのStyle再生成
		foreach ($MakeSelectBoxJS as $func) {
			print "Function:".$func."();\n";
			}
		}

	print "PostGetMPHost End\n";
	}
/* -----------------------------------------------------------------------------
	PostUpload() : Directory,File PostUpload
	$_POST host:MemoryPlayHost , dir={Path}
----------------------------------------------------------------------------- */
function PostUpload() {
	global $MPC_APPLI;

	print "PostUpload Start host[".$_POST["host"]."][".$_POST["dir"]."]\n";
	$host=$_POST["host"];
	$dir=$_POST["dir"];
$cmd= <<< EOM
result=0;
stat=\$({$MPC_APPLI} -c upload {$host} "{$dir}");
if [ \$? -ne 0 ]; then
	echo "Command:Error:update:{$host}"
	result=1;
    fi
echo "\$stat"
exit $result
EOM;
	$cmdresult=ArgTaskExec($cmd);
	$on_error="";$resary=array();$upcount=0;
	if($cmdresult !==false) {
		foreach ($cmdresult as $key => $val) {
			if(strstr($val,"Command:Error:") !== false) {
				$on_error="on";
				continue;
				}
			if($on_error !=="") {
				$resary[]=$val;
				print $val."\n";
				continue;
				}
			if(stripos($val,'detect:')!== false) {
				print $val."\n";
				$upcount=$upcount+1;
				}
			continue;
			}
		}

	if ($on_error !=="") {
		 $str = implode("",$resary);
		 $str = str_replace("'","\\'",$str);
		 $str = str_replace("\n","<BR>",$str);
		 print "Function:RequestMsgBox('UploadRequest Message','".$str."');\n";
		 print "PostUpload Error Upload Command ABEnd\n";
		 return;
		 }
	else if ($upcount == 0) {
		 print "Function:RequestMsgBox('UploadRequest Message','Upload Not applicable');\n";
		 }
	print "PostUpload End : Upload Count(".$upcount.")\n";
	}

/* -----------------------------------------------------------------------------
	PostMPStatus() : Directory,File TAG List
	$_POST host:MemoryPlayHost
----------------------------------------------------------------------------- */
function PostMPStatus() {
	if(!isset($_POST["host"])) {
		 print "idHostBox:";		// Post時 id
		 $host=DispMemoryHost();
		 print "\n";
		 }
	else {
		 $host=$_POST["host"];
		 }
	if($host !="") {
		ob_end_flush();
		print "idTagBox:";			// Post時 id
		$status=DispMHStatus($host);
		print "\n";
		}
	if((isset($_POST["monitor"]))&&($_POST["monitor"]=="1")) {		// NowMusic:monitor
		print "Function:EventNowMusic();\n";						// 非同期にBrakeされたケースで再度Timer
		}
	}

/* -----------------------------------------------------------------------------
	PostMPConnect() : Memory Play Connect Music Start
	$_POST host  :MemoryPlayHost
	       target:Diretta Target
----------------------------------------------------------------------------- */
function PostMPConnect() {
	global $MPC_APPLI;

	$host=$_POST["host"];
	$target=$_POST["target"];
	print "PostMPConnect Start host[".$host."] target[".$target."]\n";
$cmd= <<< EOM
result=0;
stat=\$({$MPC_APPLI} -c connect {$host} {$target});
if [ \$? -ne 0 ]; then
	echo "Command:Error:connect:{$host}:{$target}"
	result=1;
    fi
exit $result
EOM;
	$cmdresult=ArgTaskExec($cmd);
	if($cmdresult !==false) {
		foreach ($cmdresult as $key => $val) {
			if(strstr($val,"Command:Error:") !== false) {
				 print "Function:RequestMsgBox('ConnectRequest Message".$val."\n";
				 continue;
				 }
			else {
				 print "Connect:Reslut".$val."\n";
				 }
			}
		}

	print "PostMPConnect End\n";
	}

/* -----------------------------------------------------------------------------
	PostMPSeekTag() : Memory Play SeekTag
	$_POST host  :MemoryPlayHost
----------------------------------------------------------------------------- */
function PostMPSeekTag() {
	global $MPC_APPLI;

	$host=$_POST["host"];
	$index=$_POST["index"];
	print "PostMPSeekTag Start host[".$host."]Index[".$index."]\n";
$cmd= <<< EOM
result=0;
stat=\$({$MPC_APPLI} -c seektag {$host} {$index});
if [ \$? -ne 0 ]; then
	echo "Command:Error:seektag:{$host}"
	result=1;
    fi
exit $result
EOM;
	$cmdresult=ArgTaskExec($cmd);
	if($cmdresult !==false) {
		foreach ($cmdresult as $key => $val) {
			print "seektag:Reslut".$val."\n";
			}
		}
	print "PostMPSeekTag End\n";
	}

/* -----------------------------------------------------------------------------
	PostMPDisconnect() : Memory Play Disconnect Music Stop
	$_POST host  :MemoryPlayHost
----------------------------------------------------------------------------- */
function PostMPDisconnect() {
	global $MPC_APPLI;

	$host=$_POST["host"];
	print "PostMPDisconnect Start host[".$host."]\n";
$cmd= <<< EOM
result=0;
stat=\$({$MPC_APPLI} -c quit {$host});
if [ \$? -ne 0 ]; then
	echo "Command:Error:disconnect quit:{$host}"
	result=1;
    fi
exit $result
EOM;
	$cmdresult=ArgTaskExec($cmd);
	if($cmdresult !==false) {
		foreach ($cmdresult as $key => $val) {
			print "Disconnect:Reslut".$val."\n";
			}
		}

	print "PostMPDisconnect End\n";
	}

/* -----------------------------------------------------------------------------
	PostMPDisconnect() : Memory Play Disconnect Music Stop
	$_POST host  :MemoryPlayHost
----------------------------------------------------------------------------- */
function PostMPSeek() {
	global $MPC_APPLI;

	$host=$_POST["host"];
	$sec=$_POST["sec"];
	print "PostMPSeek Start host[".$host."]sec[".$sec."]\n";
$cmd= <<< EOM
result=0;
stat=\$({$MPC_APPLI} -c seek {$host} {$sec});
if [ \$? -ne 0 ]; then
	echo "Command:Error:seek:{$host}"
	result=1;
    fi
exit $result
EOM;
	$cmdresult=ArgTaskExec($cmd);
	if($cmdresult !==false) {
		foreach ($cmdresult as $key => $val) {
			print "seek:Reslut".$val."\n";
			}
		}
	print "PostMPSeek End\n";
	}

/* -----------------------------------------------------------------------------
	PostMPMusicPoint() : Memory Play Position
----------------------------------------------------------------------------- */
function PostMPMusicPoint() {
	global $MPC_APPLI,$MPC_EXECSEC,$MPC_CORRECTSEC,$MPC_ARY_STS;	// $MPC_EXECSEC:MemoryPlay実行Sec , $MPC_CORRECTSEC:MemoryPlayから取得時間の補正 , $MPC_ARY_STS:Status種類取得時チェック用

	$command = $MPC_APPLI;							// {Path}/MemoryPlayController : (引数なし常駐モードで数秒実行)
	$descriptorspec = [
		1 => ['pipe', 'w'],	// stdoutを読み取る
		2 => ['pipe', 'w'],	// stderrを読み取る（オプション）
		];
	$process = proc_open($command,$descriptorspec,$pipes);

	if (is_resource($process)) {
		stream_set_blocking($pipes[1], false);		// プロセスの標準出力を非ブロッキングモードに設定
		$startTime = time();						// 今現在の残時間
		$cmdresult=array();
		$str_lasttime="";
 		while (time() - $startTime < $MPC_EXECSEC) {		// 最大5秒間動かす。実験で安定Secを設定]
			$output = stream_get_contents($pipes[1]);		// 標準出力からデータを取得
			if ($output) {
//				print $output."<BR>";
				$output=str_replace("\n","",$output);
				if(strpos($output,'GetMessage LastTime=') !== false){	// 明確な仕様がないが，残Secの方が正しそう
					 $str_lasttime=$output;
					 break;
					 }
				else {
					 $cmdresult[]=$output;			// 標準出力に表示
					 }
				}
			usleep(100000);							// CPU使用率を下げるための待機（0.1秒）
			}
		proc_terminate($process);					// プロセスを終了
		fclose($pipes[1]);
		fclose($pipes[2]);
		proc_close($process);

		$resultstr=implode("",$cmdresult);
		$resultstr=str_replace("\n","",$resultstr);
		$mpno="";$mpsec="";$mptitle="";
//		preg_match_all('/Tag=(\d+:\d+):/', $resultstr, $part);					// Tag={d}:{dd}:(Titleなし)を抽出(最新と比較できないが動作可)
		preg_match_all('/Tag=(\d+:\d+:[^:]+?)FrameType/',$resultstr, $part);	// Tag={d}:{dd}:{Title}FrameTypeを抽出
		if (isset($part[1])) {
			foreach ($part[1] as $key => $val) {
				$ary = explode(":", $val,3);		// print "key[".$key."]No[".$ary[0]."]Sec[".$ary[1]."]Title[".$ary[2]."]<BR>";
				$mpno=$mpno."'".$ary[0]."',";
				$mpsec=$mpsec."'".$ary[1]."',";
				if(isset($ary[2])) {
					$tmp=str_replace("'","\\'",$ary[2]);
					$mptitle=$mptitle."'".$tmp."',";
					}
				}
		 	}
			$mpno="mpno = [".$mpno."];";
			$mpsec="mpsec = [".$mpsec."];";
			print "Function:".$mpno.$mpsec."\n";
			if($mptitle !=="") {
				$mptitle="mptitle = [".$mptitle."];";
				print "Function:".$mptitle."\n";
				}
		$resultstr=str_replace("Play Last Time"," ",$resultstr);	// $resultstr:GetMessage Status=PlayPlay Lastとなるので分解できない
		if (preg_match('/GetMessage Status=(\w+)/',$resultstr, $match)) {
			$status = $match[1];									// Disconnect/Play..が格納される
			$str=strtolower($status);								// Getした文字列が妥当かStatusから判断
			if (in_array($str,$MPC_ARY_STS)) {						//  作成者によるところが大きいので、大小文字はチェックしない
				print "Function:mpStatus='".$status."';\n";
				}
			}
		if (preg_match('/GetMessage LastTime=(\w+)/',$str_lasttime, $match)) {
			$sec = $match[1];
			$sec=intval($sec)-$MPC_CORRECTSEC;
			print "Function:mpLasttime='".$sec."';\n";
			}
		}
	}


/* -----------------------------------------------------------------------------
	PostMakeConfig() : Post make Configration
	$_POST MPC_PATH    : $MPC_PATH    : MemoryPlayControllerのDirectory Path
	       MPC_APPNAME : $MPC_APPNAME : MemoryPlayControllerのDirectory Path
	       SEL_HOMEDIR : $SEL_HOMEDIR : Directory 選択のTop Path 未設定時 「/」から検索
	       MPD_DOCROOT : $MPD_DOCROOT : Directory 連携のMPDWEB Document Root
	     Clientで効果の設定
	       MPC_MONITOR : $MPC_MONITOR : Monitore EventLoop on/off
	$MPC_CONFIGPATH = __DIR__ . '/mpdDiretta_setting.php'のPHPファイルを設定ファイルとして作成
----------------------------------------------------------------------------- */
function PostMakeConfig() {
	global $MPC_CONFIGPATH;					// 設定ファイルのパス

	print "PostMakeConfig Make start\n";				

	$mpcPath = $_POST['MPC_PATH'] ?? '';				// 入力値を取得
	$mpcAppName = $_POST['MPC_APPNAME'] ?? '';
	$mpcMonitor = $_POST['MPC_MONITOR'] ?? '';
	$selHomeDir = $_POST['SEL_HOMEDIR'] ?? '';
	$selDocRoot = $_POST['MPD_DOCROOT'] ?? '';
// Input Cheack
	if(!is_dir($mpcPath)){
		print "Function:RequestMsgBox('MakeConfig Message','MemoryPlayControllerPath(MPC_PATH)<BR> directory does not exist');\n";
		return;
		}
	$str=rtrim($mpcPath,"/")."/".trim($mpcAppName,"/");
	if(!file_exists($str)){
		print "Function:RequestMsgBox('MakeConfig Message','MemoryPlayControllerFileName (MPC_APPNAME)<BR> Appliction does not exist');\n";
		return;
		}
	if(!is_dir($selHomeDir)){
		print "Function:RequestMsgBox('MakeConfig Message','MusicFilePath(SEL_HOMEDIR)<BR> directory does not exist');\n";
		return;
		}
	if(($selDocRoot!=="")&&(!is_dir($selDocRoot))){
		print "Function:RequestMsgBox('MakeConfig Message','MusicFilePath(MPD_DOCROOT)<BR> directory does not exist');\n";
		return;
		}
// Monitor
	$mpcMonitor=strtolower($mpcMonitor);				// 設定ファイルの内容を作成
	if($mpcMonitor !=="on") {
		$mpcMonitor="off";
		}
	$configContent = <<<CONFIG
\$MPC_PATH = "$mpcPath"; 		// MemoryPlayControllerのDirectory Path
\$MPC_APPNAME = "$mpcAppName";	// MemoryPlayControllerのFile Name
\$MPC_MONITOR = "$mpcMonitor";
\$SEL_HOMEDIR = "$selHomeDir";	// Directory 選択のTop Path 未設定時 「/」から検索
\$MPD_DOCROOT = "$selDocRoot";	// Directory 連携のMPDWEB Document Root
CONFIG;
	$configContent="<?php\n".$configContent."\n?>";
	file_put_contents($MPC_CONFIGPATH, $configContent);		// 設定ファイルに書き込み

	print "Function:EventMakeModeUp('".$mpcMonitor."');RequestMsgBox('MakeConfig Message','Update Complete');document.getElementById('idconfig').style.display='none';\n";
	print "Function:MPC_MONITOR='".$mpcMonitor."';\n";		// 設定ファイルJSに即時反映
	print "PostMakeConfig Make End\n";
	}


/* -----------------------------------------------------------------------------
	PostMPStart() : Memory Play Host Start
	※テストモード: 実行パーミッションを合わせないと動作しない
----------------------------------------------------------------------------- */
function PostMPStart() {
	global $MP_SERV,$MP_BASE;

	print "PostMPStart Start\n";

	if ($MP_EXEC == "") {
		 $exec_cmd=$MP_SERV;
		 }
	else {
		 $exec_cmd=$MP_EXEC;
		 }
$cmd= <<< EOM
mptask=\$(ps -ef | grep {$MP_BASE} | grep -v 'grep {$MP_BASE}')
if [ -z "\$mptask" ]; then
	$MP_SERV  > /dev/null &
fi
EOM;
	$cmdresult=ArgTaskExec($cmd." > /dev/null &");
	print "PostMPStart Memory Play KickStart";
$cmd= <<< EOM
mptask=\$(ps -ef | grep {$MP_BASE} | grep -v 'grep {$MP_BASE}')
echo "\$mptask"
EOM;
	$i= 0;
	while(true) {
	    sleep(1);
		$cmdresult=ArgTaskExec($cmd);
		if($cmdresult !==false) {
			foreach ($cmdresult as $key => $val) {
				if(strstr($val,$MP_BASE) !== false) {
					print "PostMPStart Memory Play Start OK!";
					$i = 10;
					break;
					}
				}
			}
		$i = $i + 1;
		if ($i >= 10) {
     		break;
			}
		}
	print "PostMPStart End\n";
	}

/*******************************************************************************
	HTML Definition
*******************************************************************************/
$SCR_WIDTH=480;

echo <<<EOM
<html lang="ja"><link rel="shortcut icon" href="./mpdwebfavicon.ico"><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" ><meta http-equiv="Expires" content="1000">
<meta id="idMeta" name="viewport" name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.7">
<script type="text/javascript">
var POSTMOD="{$_SERVER['PHP_SELF']}";		// POST ServerModule
/* View Port 設定 */
var getDevice = (function(){
		var ua = navigator.userAgent;
		if(ua.indexOf('iPhone') > 0 || ua.indexOf('iPod') > 0 || ua.indexOf('Android') > 0 && ua.indexOf('Mobile') > 0){
			 return 'sp';
			 }
		else if(ua.indexOf('iPad') > 0 || ua.indexOf('Android') > 0){
			 return 'tab';
			 }
		else {
			 return 'other';
			 }
		})();
if ((getDevice == 'sp' )||(getDevice == 'tab' )){
	 scale=Math.floor((window.outerWidth/{$SCR_WIDTH})*100)/100;	// 幅比率で表示(小数3位切り捨て)
	 var viewportContent="width=380,initial-scale="+String(scale)+",maximum-scale=1.7";
	 document.getElementById('idMeta').setAttribute('content',viewportContent);
	 }

</script>
EOM;
?>
<script type="text/javascript">
var ERSTR = 'ERR';
var IDSTS = 'stdout';
/* -----------------------------------------------------------------------------
	RequestByPost(module,para,callback) : Post Request
		module  : i  : Post Module
		para    : i  : Post Parameter
		callback: i  : Callback
	 Post reception format
	  Value: {string}={string} : Set constant in JS item JS定数設定
	  Function:{function}      : Performing JS functions JS関数実行
	  {HTML ID}]:{Display-HTML}: HTML ID Display
	  String                   : Status Line Display
------------------------------------------------------------------------------ */
function RequestByPost(module,para,callback) {
	if (callback == null) { callback=''; }
	if(window.addEventListener) {									// Firefox
		  var request = new XMLHttpRequest();						// Ajax Request Function
		  }
	 else {															// IE
		  var request =  new ActiveXObject("Microsoft.XMLHTTP");	// Ajax Request Function
		  }
	/* ステータス( 読み込み中なのか完了したのか) が変更されたら readyStateChangeHandler を実行 */
	request.open("POST", module , true);
	request.onreadystatechange = readyStateChangeHandler;
	request.setRequestHeader( "Content-Type" ,  "application/x-www-form-urlencoded");
	request.send(para);
	function readyStateChangeHandler(){								// Receive Completion
		switch(request.readyState){
			case 4:
				if(request.status == 200) {							// 完了時
					var res_ans = request.response.split("\n");
					var response = "";var last_msg = "";var err_msg = "";
					for(var i=0; i < res_ans.length ; i++ ) {
						if (res_ans[i] == "") {  continue; }
						var htm_id = res_ans[i].split(":",2);
						var htm_id_str = res_ans[i].replace(htm_id[0]+":","");
					// Form : Value Value:が検出されたときは，変数の変更 : "^"先頭一致
						if ((htm_id.length>=2)&&(htm_id[0].match(RegExp("^value","i")))) {		// Receive: Value: {string}={string}
							var valstr = htm_id[1].split("=",2);
							if (valstr.length >=2) {
								var chgstr=res_ans[i].replace(htm_id[0]+":"+valstr[0]+"=","");	// splitは切り捨てのためValue:{string}を""に置換
								eval(valstr[0] + "= "+chgstr);
								continue; 
								}
							}
					// Form : Function Function:が検出されたときは，以下をFunctionと扱う : "^"先頭一致
						if (res_ans[i].match(RegExp("^Function","i"))) {						// Receive: Function:{function}
							try {
								eval(htm_id_str);
								} catch (e) {
								response=response+"Callback:Errror "+e+"\n";					// エラーを検知
								}
							continue;
							}
					// Form : {HTML ID}]:{Display} HTML IDが存在時に表示
						if (htm_id.length>=2) {
							if (document.getElementById(htm_id[0]) != null) {					//  HTML-IDがあれば表示する。
								var idobj = document.getElementById(htm_id[0]);
								idobj.outerHTML=htm_id_str;
								continue;
								}
							}
						response=response+res_ans[i]+"\n";			// 形式なしはメッセージとする
						if  (res_ans[i].match(RegExp(ERSTR,"i"))) {	// 引数のError MessageWordと一致？
							 err_msg  = res_ans[i]; }
						else {
							 last_msg = res_ans[i]; }
						}
				// Case End Process
					var out = document.getElementById(IDSTS);
					if (err_msg != "") {							// 先頭はErrorの行を優先し表示
					 	 out.innerHTML = err_msg  + "\n"; }
					else {
						 out.innerHTML = last_msg + "\n"; }
					out.innerHTML += response;
				// Call Back
					if (callback != '') {
						callback();
						}
					}
			break;
			}
		}
	}

/* -----------------------------------------------------------------------------
	PostSearchRequest() : Post Request : Directory Search
	Request:Path
------------------------------------------------------------------------------ */
function PostSearchRequest() {
	var str=document.getElementById('idUploadPath').textContent;
	var dir=document.getElementById('idEditDir').textContent=str;
	var dir=encodeURIComponent(dir);
	RequestByPost(POSTMOD,'p=getdir&dir='+dir);
	}

/* -----------------------------------------------------------------------------
	PostGetHostRequest() : Post Request : Get Memory Play Host
------------------------------------------------------------------------------ */
function PostGetHostRequest() {
	RequestLoadDisp(10);
	RequestByPost(POSTMOD,'p=gethost',function(){ RequestUnLoadDisp(); });
	}

/* -----------------------------------------------------------------------------
	PostGetTarget() : Post Request : Get Memory Play Host->Target
	$_POST host={Select Host}
------------------------------------------------------------------------------ */
function PostGetTarget() {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		RequestMsgBox('GetTargetRequest','Start the MemoryPlay Service');
		return;
		}
	var host = document.getElementById('idHostIP').value;
	RequestByPost(POSTMOD,'p=gethost&host='+host,function(){ PostMPStatusRequest(); });
	}

/* -----------------------------------------------------------------------------
	PostUploadRequest() : Post Request : Upload
	Request:host / Directory,file
------------------------------------------------------------------------------ */
function PostUploadRequest() {
	var dir=document.getElementById('idUploadPath').textContent;
	if(dir !=="") {
		 dir=encodeURIComponent(dir);
		 var host=document.getElementById('idHostSel').textContent;
		 host=encodeURIComponent(host);
		 RequestByPost(POSTMOD,'p=upload&host='+host+'&dir='+dir,function(){ SetStsteIntervI=0;RequestUnLoadDisp();PostMPStatusRequest(); });
		 document.getElementById('idUpload').style.color='';
		 RequestLoadDisp(180);
		 const tbody = document.querySelector('#idMPTagTbl tbody');			// MemoryPlayTagTable Clear
		 tbody.innerHTML = '';
		 SetStsteIntervI=1;				// Interval Event Loop開始
		 EventMPStat();
		 document.getElementById('idMpTotalStr').textContent="";
		 EventMusicPoint_Clear();
		 }
	else {
		 RequestMsgBox('UploadRequest','After selecting Directory/Files from "Search"');
		 }
	}

/* -----------------------------------------------------------------------------
	PostMPStatusRenew(noDisp) : Post Renew  (Status:Hostを検知 Header部の再生成)
	noDisp  : i  : "":on:RequestLoadDisp() ,"1":off:RequestLoadDisp() 
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function PostMPStatusRenew(noDisp) {
	if(noDisp == null) { noDisp=""; }
	const tbody = document.querySelector('#idMPTagTbl tbody');			// MemoryPlayTagTable Clear
	tbody.innerHTML = '';
	document.getElementById('idUpload').style.color='';
	if(noDisp=="") {
		RequestLoadDisp(10);
		}
	RequestByPost(POSTMOD,'p=status&monitor='+mpMonitor,function(){ RequestUnLoadDisp(); });
	document.getElementById('idMpTotalStr').textContent="";
	EventMusicPoint_Clear();
	}

/* -----------------------------------------------------------------------------
	PostMPStatusRequest() : Post Status & TAG List (SelectHostのTarget/TagList)
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function PostMPStatusRequest() {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		RequestMsgBox('StatusRequest','Start the MemoryPlay Service');
		return;
		}
	host=encodeURIComponent(host);
	RequestByPost(POSTMOD,'p=status&host='+host+'&monitor='+mpMonitor);
	}

/* -----------------------------------------------------------------------------
	PostConnectRequest() : Post MemoryPlay Connect
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function PostConnectRequest() {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		RequestMsgBox('StatusRequest','Start the MemoryPlay Service');
		return;
		}
	var target=document.getElementById('idTarget').value;
	if(target =="") {
		RequestMsgBox('StatusRequest','Prepare the Diretta Target');
		return;
		}
	if((document.getElementById('idMPStat').textContent == "Play")&&(mpMonitor == 1)) {
		return;										// 「Play」中Connectは停止してしまうが、モニタモード時抑制する。
		}
	host=encodeURIComponent(host);
	target=encodeURIComponent(target);
	RequestByPost(POSTMOD,'p=connect&host='+host+'&target='+target,function(){ PostMPStatusRequest();if (mpMonitor==1) { PostMusicReGet();} });
	}

/* -----------------------------------------------------------------------------
	PostMPSeektagRequest(index) : Post Memory Play Seek Tag
	index : i  : Play Tag.index:0～
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function PostMPSeektagRequest(index) {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		return;
		}
	host=encodeURIComponent(host);
	RequestByPost(POSTMOD,'p=seektag&host='+host+'&index='+index,function(){ _PostMPSeektagRepost(); });
	}
/* Memory Playの反応から数秒Wait( SeekTagが動作すれば良いのでStatusGetで負荷を掛けない ) */
function _PostMPSeektagRepost() {
	if (mpMonitor==1) {
		EventMusicPoint_Clear();
		PostMusicReGet();
		}
	}

/* -----------------------------------------------------------------------------
	PostMPDisconnectRequest() : Post Memory Play Disconnect
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function PostMPDisconnectRequest() {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		RequestMsgBox('StatusRequest','Start the MemoryPlay Service');
		return;
		}
	EventMusicPoint_Status("Disconnect");			// 先に表示しておく
	host=encodeURIComponent(host);
	RequestByPost(POSTMOD,'p=disconnect&host='+host,function(){ if (mpMonitor==1) { EventMusicPoint_Clear(); } PostMPStatusRequest(); });
	}

/* -----------------------------------------------------------------------------
	PostMPSeekRequest() : Post Seek (Sec)
	$_POST host={Select Host}
	$_POST host=sec(idSeekSec)
----------------------------------------------------------------------------- */
function PostMPSeekRequest() {
	var sec=document.getElementById('idSeekSec').textContent;
	if(sec == 0) { return; }
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		return;
		}
	host=encodeURIComponent(host);
	if (sec > 0) {
		 var csec="+"+sec;
		 if (csec >= mpLasttime) {			// Last:Seek
			EventMusicPoint_Clear();
			}
		 }
	else {						// 戻しは未テスト
		 var csec="-"+sec;
		 }
	RequestByPost(POSTMOD,'p=seek&host='+host+'&sec='+csec,function(){ _PostMPSeektagRepost(); });
	}

/* -----------------------------------------------------------------------------
	EventMPStat() : Post Status Request IntervaI UPLoad時のUpload状態監視(現在，PostUploadRequestで使用)
------------------------------------------------------------------------------ */
var SetStsteCount=0;				// Count:Count*SetStsteWaitで経過時間をGet
var SetStsteIntervI=0;				// EventMPStat()をCallingでSetStsteIntervI(0)までLoop
var SetStsteWait=2000;				// Interval Time(msec)
var SetStsteTime=180000;			// この時間(msec)を超えると終了まで監視しない。(Uploadは続行)
/*
	EventMPStat() : Post Status Request IntervI ※monitorモードとは無関係
*/
function EventMPStat() {
	var host=document.getElementById('idHostSel').textContent;
	if(host =="") {
		SetStsteCount=0;
		return;
		}
	host=encodeURIComponent(host);
	if (SetStsteIntervI == 1) {
		if(SetStsteCount==0) {		// 初回はTimerセット(同時Postを避ける)
			setTimeout(EventMPStat,SetStsteWait)
			SetStsteCount=1;
			return;
			}
		SetStsteCount=SetStsteCount+1;
		if((SetStsteCount*SetStsteWait)>=SetStsteTime) {
			SetStsteCount=0;
			return;
			}
		RequestByPost(POSTMOD, 'p=status&host=' + host, function () {
			if (SetStsteIntervI == 1) { 
				setTimeout(EventMPStat,SetStsteWait); // 次回の呼び出しを設定
				}
			});
		 }
	else {
		 SetStsteCount=0;
		 }
	}

/* *****************************************************************************
	EventHost_Change() : Host Chenge & Get Target
	※SelectHostがLocalの場合,Monitorが有効となる
***************************************************************************** */
function EventHost_Change() {
	var host = document.getElementById('idHostIP').value;
	var host_new=host;
	var Selhost=document.getElementById('idHostSel').textContent;
	if(host == Selhost) { return; }
	host=encodeURIComponent(host);
	RequestLoadDisp(10);
	mpMonitor=0;						// Timer Event終了させる
	if(mpTimerid) {
		clearTimeout(mpTimerid);
		}
	RequestByPost(POSTMOD,'p=gethost&host='+host,function(){ EventHost_ChangeMonitor(host_new);RequestUnLoadDisp(); });
	}

/*
	EventHost_ChangeMonitor(host) : EventListener MutationObserver : Host Change [Select]
	host  : i  : Select Host
*/
function EventHost_ChangeMonitor(host) {
	console.log('EventHost_ChangeMonitor Host['+host+']');
	var idHost=document.getElementById('idHostSel');
	if (host.startsWith('::1,')) {
		 EventMakeModeUp(MPC_MONITOR);
		 PostMusicPoint();
		 }
	else {
		 EventMakeModeUp('off');
		 EventMusicPoint_Clear();
		 }
	}

/* *****************************************************************************
	MemoryPlay SeekSec Seek Sec Count
***************************************************************************** */
var MPSeekSec=30;
var MPSeekMin=30;
var MPSeekMax=90;
/* -----------------------------------------------------------------------------
	EventSeekSec() : Seek Sec Count
	$_POST host={Select Host}
----------------------------------------------------------------------------- */
function EventSeekSec() {
	var sec=document.getElementById('idSeekSec').textContent;
	if(sec >= MPSeekMax) {
		 sec=MPSeekMin;
		 }
	else {
		 sec=Number(sec)+MPSeekSec;
		 }
	document.getElementById('idSeekSec').textContent=sec;
	}

/* ****************************************************************************
	EventMusicMonitorClick() : Post Play Point Mark
	----------------------------------------------------------------------
	PostMusicPoint() : Monitorの開始 [Mon(itor)Buttonで開始時使用]
	PostMusicReGet() : MonitorのTimerを停止し，Statusを最新化し再開
	                   二重Timerにならないように強制停止する
	EventNowMusic()  : TimerSet&Loop 仮想Time表示/一定時間で最新StatusGet
	EventMusicGet()  : MonitorのためのStatusをRequest。GetSuatusを反映する
***************************************************************************** */
function EventMusicMonitorClick() {
	var local=0;
	var hostipv6=document.getElementById('idHostSel').textContent;
	if (hostipv6.startsWith('::1,')) {
		local=1;
		}
	var str= document.getElementById("idMon").style.color;
	var str = str.replace(/[^0-9]/g, '');
	if (parseInt(str,10) ==0) {
		 if(local==0) {
			RequestMsgBox('Monitor Event Request','Remote PC cannot be turned on');
			return;
			}
		 document.getElementById("idMon").style.color="#008000";
		 PostMusicPoint();
		 }
	else {
		 document.getElementById("idMon").style.color="#000000";
		 mpMonitor=0;
		 }
	}

/* ----------------------------------------------------------------------------
	PostMusicPoint() : EventNowMusicを現在のPlay状況をPost後CallBackでStartする。
----------------------------------------------------------------------------- */
function PostMusicPoint() {
	mpMonitor=1;
	RequestByPost(POSTMOD,'p=musicpoint',function(){ EventMusicGet();EventNowMusic(); });
	}

/*
	PostMusicReGet(noDisp): EventNowMusicを現在のPlay状況をPost後,Timer解除後,CallBackでRestartする。
	noDisp  : i  : "":on:RequestLoadDisp() ,"1":off:RequestLoadDisp() 
*/
function PostMusicReGet(noDisp) {
	if(noDisp == null) { noDisp=""; }
	mpMonitor=0;						// Timer Event終了させる
	clearTimeout(mpTimerid);
	RequestByPost(POSTMOD,'p=musicpoint',function(){ clearTimeout(mpTimerid);mpMonitor=1;EventMusicGet(noDisp);EventNowMusic(); });
	}

/// Timer:NowMusic 設定項目として使用する -----------------------------------------
var mpNowMusicWait  =   2000;	// Play NowMusic Sleep(mSec)          :内部での秒カウント
var mpNowMusicReGet =  30000;	// Play NowMusic SleepのReet(mSec)    :現在のMPでの再生位置
var mpStatusWait    =  60000;	// Status"Play"でない場合のSleep(mSec):なにもしないが外部からPlayになれば反映
var mpStatusReGet   = 120000;	// Status"Play"でない場合のReet(mSec) :最新化 All Status Get
/// Timer:NowMusic Global項目として使用する -----------------------------------------
var mpLasttime="";			// Post:MemoryPlay Lasttime(sec) (実際の値はp=musicpointで設定する)
var mpMusic_Point=0;		// 現在PlayPoint:EventMusicPoint()で設定
var mpMonitor=0;			// 1:Timer監視 , 0:Timer監視終了指示

var mpNowMusicCnt = 0;		// Status"Play"場合のSleep Count(Sec)      :mpNowMusicReGetまでのCounter
var mpStatusCnt = 0;		// Status"Play"でない場合のSleep Count(Sec):mpStatusReGetまでのCounter

var mpTimerid;				// Global TimerIDを保持 [clearTimeout()]
/* ----------------------------------------------------------------------------
	EventNowMusic() : MemoryPlay : Now Music
----------------------------------------------------------------------------- */
function EventNowMusic() {
	if(mpMonitor == 0) {											// Mon.Clickで終了
		EventMusicPoint_Clear();
		return;
		}
	var inttimer= mpNowMusicWait;									// 基本Timer(最小)

	var sts = document.getElementById('idMPStat').textContent;
	if (sts =="Pause") { 
		 if(mpStatusCnt > mpStatusReGet) {							// Psuse,Disconnect,一定時間後Reget
			mpStatusCnt=0;
			RequestByPost(POSTMOD,'p=status',function(){ PostMusicReGet(1); });
			return;
			}
		 inttimer=mpStatusWait;										// PlayでないときのTimerSet
		 mpStatusCnt=mpStatusCnt+inttimer
		 }
	else if (sts !=="Play") {
		if (mpLasttime !=="") {			// PlayからDisconnectになったとき、PlayPointをクリアする
			EventMusicPoint_Clear();
			mpLasttime="";
			}
		 if(mpStatusCnt > mpStatusReGet) {							// Play(Disable)でない場合,一定時間後Reget
			mpStatusCnt=0;
			RequestByPost(POSTMOD,'p=status',function(){ PostMusicReGet(1); });
			return;
			}
		 inttimer=mpStatusWait;										// PlayでないときのTimerSet
		 mpStatusCnt=mpStatusCnt+inttimer
		 }
	else {
		 if(mpNowMusicCnt > mpNowMusicReGet) {						// Play:一定時間後Reget
			  mpNowMusicCnt=0;
			  PostMusicReGet();
			  return;
			  }
		 else {
			  var mpTagtb = document.getElementById('idMPTagTbl');
			  if(EventNowMusic_Next(mpTagtb)==false) {
				  if(mpLasttime =="") {
					    inttimer=mpStatusWait;							// Play(全曲終了)でないときのTimerSet
						}
				   else {
					    mpLasttime=mpLasttime-(mpNowMusicWait/1000);	// PlayPointのStart Sec
						}
				   }
			  else {
				   mpLasttime=mpLasttime-(mpNowMusicWait/1000);			// PlayPointのStart Sec
				   var Start_sec=_EventMusicPoint_Start(mpTagtb,mpMusic_Point);
				   var tbtime=mpTagtb.rows[mpMusic_Point].cells[1].textContent;
				   var edtime=_EventNowMusicEditTime(Start_sec,tbtime);
				   var nowtime = document.getElementById('idNowTime');
				   nowtime.textContent=edtime;
				   }
		 	 }
		 mpNowMusicCnt=mpNowMusicCnt+inttimer;
		 }
	mpTimerid=setTimeout(EventNowMusic,inttimer); 		// Timer Loop
	}

/* ----------------------------------------------------------------------------
	EventNowMusic_Next() : NextMusic?
	@return : o  : true :NowPoint Continue : PlayPoint,Count続行
	               false:Play NextPoint : 次のPlayPointにする。(現曲を終了の意味でflase)
                      or End Play  status:Disconnect，mpLasttime=""にする。
----------------------------------------------------------------------------- */
function EventNowMusic_Next(mpTagtb) {
	var End_sec=_EventMusicPoint_End(mpTagtb,mpMusic_Point);	// NowPlay Get End Point
	if (mpLasttime > End_sec) {									// 残TimeがEndを超すとNext
		return(true);
		}
	var point = mpMusic_Point + 1;					// 最終Play Point?
	var Start_sec=_EventMusicPoint_Start(mpTagtb,point);
	if(Start_sec == false) {						// 全てPlayEnd
		EventMusicPoint_Status("Disconnect");		// MemoryPlayが終了していたので合わせる。
		EventMusicPoint_Clear();
		mpLasttime="";
		return(false);
		}
	mpMusic_Point = mpMusic_Point + 1;				// Next PlayPointを表示
	var tbtime=mpTagtb.rows[mpMusic_Point].cells[1].textContent;
	var edtime=_EventNowMusicEditTime(Start_sec,tbtime);
console.log("EventNowMusic_Next:edtime["+edtime+"]tbtime["+tbtime+"]Start_sec["+Start_sec+"] mpLasttime["+mpLasttime+"]");
// PlayPointの位置にTimeをセット
	var ele=mpTagtb.rows[mpMusic_Point];
	var bounds = ele.getBoundingClientRect();
	var x=bounds.left;		// xは未使用
	var y=bounds.top;
	_EventMusicPoint_Disp(mpTagtb,mpMusic_Point,y,edtime);
	return(false);
	}

// Post:MemoryPlay Status(p=musicpointで設定される
var mpStatus="";			// 各処理では独立した動作したいのでEventMusicGet以外は参照しない)
/* ----------------------------------------------------------------------------
	EventMusicGet(noDisp) : MemoryPlay Point Get
	noDisp  : i  : "":on:RequestLoadDisp() ,"1":off:RequestLoadDisp() 
----------------------------------------------------------------------------- */
function EventMusicGet(noDisp) {
	if(noDisp == null) { noDisp=""; }
	now = new Date();
	console.log(now.getHours()+":"+now.getMinutes()+":"+now.getSeconds()+" mpLasttime["+mpLasttime+"] mpStatus["+mpStatus+"]");

	if(typeof mpno == 'undefined') {
		mpLasttime="";
		}
	if(mpStatus !=="Play") {						// Play以外では，LastTimeが当てにならない
		EventMusicPoint_Status(mpStatus);			// MemoryPlayが終了していたので合わせる。
		mpLasttime="";
		}
/* -- HTML / MemoryPlay I/F ----
	HTML table:[0]:Title行
	               cells[0]:No,[1];Time,[2]:Title,[3]:Sec(MP)
	MemoryPlay:[0]:Reset 0Sec, [Last]Total,Title:"@@Diretta-TAG-QUIT"
                   mpno[]:行数[1]から mpsec[]:Play残Sec,
               mpLasttime:現在の残り時間(Disconnect時無効),mpStatus:MemoryPlay Status
*/
	var mpTagtb = document.getElementById('idMPTagTbl');
	var mpTagtblng = mpTagtb.rows.length;
	var flgdef="";
	if (typeof mptitle !== 'undefined') {
		if (mpTagtblng == (mpno.length-1)) {		// MempryPlayと表示タイトル行数が同じかチェック
			for (var i=0;i < mpTagtblng;i++) {
				if (i==0) { continue; }				// HTML table:Rows[0]:Title行 , MemoryPlay:[0]:(reset)
				if(mpTagtb.rows[i].cells[2].textContent !== mptitle[i]) {
					flgdef="Def:On";
					}
				}
			 }
		else {
			 flgdef="No:On";
			 }
		if(flgdef !=="") {
			PostMPStatusRenew(noDisp);				// 状態が変わったときは最新化
			return;
			}
		}
// HTML TotalSecをセットしておく。
	var total=document.getElementById('idMpTotal').textContent;
	if(mpsec.indexOf(mpTagtblng)) {
		total=mpsec[mpTagtblng];
		document.getElementById('idMpTotal').textContent=mpsec[mpTagtblng];
		}
// HTML <table>...<td>最後隠し項目で PlaySec:cells[3] / Play残Sec:cells[4] をセット
	for (var i=0;i < mpTagtblng;i++) {
		if (i==0) { continue; }						// Rows0:Title行
		mpTagtb.rows[i].cells[3].textContent=mpsec[i];
		mpTagtb.rows[i].cells[4].textContent=total - mpsec[i];
		}
	EventMusicPoint();								// Play,Point Mark
	}

/* ----------------------------------------------------------------------------
	EventMusicPoint() : Play Point Mark : 現PlayPoint，進行位置をセット
----------------------------------------------------------------------------- */
function EventMusicPoint() {
//	console.log("EventMusicPoint mpLasttime["+mpLasttime+"]");
	if (mpLasttime =="") { return; }
	var lastsec = parseInt(mpLasttime);						// LastTime 数値として
	var mpTagtb = document.getElementById('idMPTagTbl');
	var mpTagtblng = mpTagtb.rows.length;
	for (var i=0;i < mpTagtblng;i++) {
		if (i==0) { continue; }								// Rows0:Title行
		var ele=mpTagtb.rows[i];
		var psec=parseInt(ele.cells[4].textContent);		// MemoryPlayからのSec[残](数値として)
		if(lastsec >= psec) {								// 現在のPlayPoint [Sec(残)を超えた位置]
			mpMusic_Point=i;								// Play Pointの決定
			var Start_sec=_EventMusicPoint_Start(mpTagtb,mpMusic_Point);
			var tbtime=mpTagtb.rows[mpMusic_Point].cells[1].textContent;
			var edtime=_EventNowMusicEditTime(Start_sec,tbtime);
//			PlayPointの位置にTimeをセット
			var bounds = ele.getBoundingClientRect();
			var x=bounds.left;			// xは未使用
			var y=bounds.top;
			_EventMusicPoint_Disp(mpTagtb,mpMusic_Point,y,edtime);
			break;
			}
		}
	}

/*
	_EventMusicPoint_Start(mpTagtb,point) : Get Sec,PlayPount : 指定PountのStartTime(sec)
	mpTagtb  : i  : HTML-id:'idMPTagTbl'Object
	point    : i  : Target Point 'idNowTime'のRow
	@return  : o  : StartTime(sec) mpLasttime:の形式
*/
function _EventMusicPoint_Start(mpTagtb,point) {
	var Start_sec=0;
	if(point > 1){
		 if (point >= mpTagtb.rows.length) {
			return(false);
			}
		 var obj=mpTagtb.rows[point-1];					// 前のSec(残)を再生中の初期値とする)
		 Start_sec=parseInt(obj.cells[4].textContent);
		 }
	else {
		 Start_sec = parseInt(document.getElementById('idMpTotal').textContent);
		 }
	return(Start_sec);
	}

/*
	_EventMusicPoint_End(mpTagtb,point) : Get Sec,Play End Pount : 指定PountのEndTime(sec)
	mpTagtb  : i  : HTML-id:'idMPTagTbl'Object
	point    : i  : Target Point 'idNowTime'のRow
	@return  : o  : End Time(sec) mpLasttime:の形式
*/
function _EventMusicPoint_End(mpTagtb,point) {
	var obj=mpTagtb.rows[point];						// Play中の(残)Get
	End_sec=parseInt(obj.cells[4].textContent);
	return(End_sec);
	}

/*
	_EventNowMusicEditTime(Start_sec,tbtime) : 経過時間編集 
	Start_sec : i  : 現在PlayPorintの先頭Sec
	tbtime    : i  : Table表示 曲のmm:ss
	return    : o  : 編集Time "[ mm:ss]"
*/
function _EventNowMusicEditTime(Start_sec,tbtime) {
	var str = Start_sec - mpLasttime;						// 先頭(残)のからの残り時間曲の経過時間(Sec)とする。
	var str = ArgJsConvTime(str);
	if(str > tbtime) {
		str=tbtime;
		}
	var result="["+str+"]";
	return(result);
	}

/*
	_EventMusicPoint_Disp(mpTagtb,point,y,str) : PlayPoinの初期値セット&表示
	mpTagtb  : i  : HTML-id:'idMPTagTbl'Object
	point   : PlayPoint
	y       : Display y 座標
	str     : Play Time
	※EventLoop開始時初回の位置決め,Loop中仮想Play位置(曲)変わったとき
*/
function _EventMusicPoint_Disp(mpTagtb,point,y,str) {
	var nowtime = document.getElementById('idNowTime');
	nowtime.style.top=y+"px";
	nowtime.style.left=406+"px";
	nowtime.style.backgroundColor="#0000ff";
	nowtime.style.color="#a5ff4c";
	nowtime.textContent=str;
	}

/* ----------------------------------------------------------------------------
	EventMusicPoint_Clear() : Play Point Mark Clear
----------------------------------------------------------------------------- */
function EventMusicPoint_Clear() {
	var nowtime = document.getElementById('idNowTime');
	nowtime.textContent="";
	nowtime.style.top="";
	nowtime.style.left="";
	nowtime.style.backgroundColor="";
	nowtime.style.color="";
	}

/* ----------------------------------------------------------------------------
	EventMusicPoint_Status(status) : Play Point Status Updat
	ststus : i  : MemoryPlay : Status
----------------------------------------------------------------------------- */
function EventMusicPoint_Status(status) {
	var objsts=document.getElementById('idMPStat');
	objsts.textContent=status;
	if (status=="Disconnect") {
		 objsts.style.backgroundColor="#bc611e";
		 objsts.style.color="#ffc0cb;";
		 }
	else if (status=="Play") {
		 objsts.style.backgroundColor="#6b8e23";
		 objsts.style.color="#ffffff";
		 }
	else {
		 objsts.style.backgroundColor="#00008b";
		 objsts.style.color="#87ceeb";
		 }
	}

/* ----------------------------------------------------------------------------
	EventMakeModeUp(mode) : Make Up,After Proc & Monitor Mode Setting
	mode : i  : on/off ※JSに設定反映
----------------------------------------------------------------------------- */
function EventMakeModeUp(mode) {
	var idMonobj=document.getElementById("idMon");
	var color=idMonobj.style.color;
	var color = color.replace(/[^0-9]/g, '');
	if((mode=="on")&&(parseInt(color,10) ==0)) {
		 idMonobj.style.color="#008000";
		 PostMusicPoint();
		 }
	else if((mode=="off")&&(parseInt(color,10) !=0)){
		 idMonobj.style.color="#000000";
		 mpMonitor=0;
		 }
	}

/* *****************************************************************************
	JavaScript Support Library
****************************************************************************** */

/* -----------------------------------------------------------------------------
	ArgAdjustmentRtl(id) : HTML DivText Adjustment (AreaOver時右寄せ)
	id     : i  : Request HTML-id
------------------------------------------------------------------------------ */
function ArgAdjustmentRtl(id) {
    const element = document.getElementById(id);
    const textWidth = element.scrollWidth;		    // Text長取得
    const containerWidth = element.offsetWidth;		// Containerの幅
	if (textWidth > containerWidth) {
		 element.style.direction = 'rtl';			// 文字列溢れ:右寄せ
		 element.style.textAlign = 'left';
		 }
	else {
		 element.style.direction = 'ltr';			// 文字列短い:左寄せ
		 element.style.textAlign = 'left';
		 }
	}

/* -----------------------------------------------------------------------------
	ArgJsConvTime(sec) : Sec to Edit Time
	sec    : i  ; Seconds
	@rettun: o  : hh:mm:ss or mm:ss
------------------------------------------------------------------------------ */
function ArgJsConvTime(sec) {
	const hh = Math.floor(sec / 3600);			// 秒を時間（3600）で割った余り
	const mm = Math.floor(sec % 3600 / 60);		// 秒を時間（3600）で割った余りを分（60）で割って切り捨て
	const ss = sec % 60;						// 秒数を分（60）で割った余り
	var str=(('00'+ mm).slice(-2))+":"+(('00'+ ss).slice(-2));
	if (hh > 0) {
		str=hh+":"+str;
		}
	return(str);
	}

var GObjSTime;				// 起動待ちの時計マーク Objectid
/* ----------------------------------------------------------------------------
	RequestLoadDisp(waitsec) : 起動待ちの時計マークディスプレイ (mpdweb標準モジュールより)
	 waitsec : i  : Display Timeout(Sec) 0:Limit(Net Timeoutまで),null:defult,{n}:指定時{n}sec
------------------------------------------------------------------------------ */
function RequestLoadDisp(waitsec){
	var sleep=null;

	if (waitsec == 0) {
		 sleep=LoadDispWSec*1000;
		 }
	else if (waitsec == null) {
		 sleep=10000;
		 }
	else {
		 sleep=waitsec*1000;
		 }
	document.getElementById('idlodingmsg').style.display='block';	// idlodingmsgを表示にする display: none;→block

	var element = document.createElement('div'); 					// ロック用のdivを生成 透明，最大画面を最上位に表示
	element.id = "screenLock"; 										// ロック用のスタイル
	element.style.height = '100%'; 
	element.style.left = '0px'; 
	element.style.position = 'fixed';
	element.style.top = '0px';
	element.style.width = '100%';
	element.style.zIndex = '100';									// PlayPanel(id=idFormCtl)よりz-indexを下げている
	element.style.opacity = '0';
	var objBody = document.getElementsByTagName("body").item(0); 
	objBody.appendChild(element);

	if(GObjSTime) { clearTimeout(GObjSTime);GObjSTime=null; }			// Timer Unloak
	GObjSTime=setTimeout( function() { RequestUnLoadDisp(); },sleep);	// ロック画面の削除
	}

/*
	RequestUnLoadDisp() 起動待ちの時計マーク解除
*/
function RequestUnLoadDisp(){
	document.getElementById('idlodingmsg').style.display='none';
	var id_name='screenLock';
	if (document.getElementById(id_name) == null) {
		return;
		}
	if(GObjSTime) { clearTimeout(GObjSTime);GObjSTime=null; }			// Timer Unloak
	var dom_obj = document.getElementById(id_name);
	var dom_obj_parent=dom_obj.parentNode;
	dom_obj_parent.removeChild(dom_obj);
	}

/* ----------------------------------------------------------------------------
	RequestMessageBox(title,str,top,left) : MessageBox (mpdweb標準モジュールにStringLength追加)
	 title: i  : Box Title
	 str  : i  : Message
----------------------------------------------------------------------------- */
function RequestMsgBox(title,str,top,left) {
	str=str.replace(/<BR>/g, "\n");
	var ary=str.split("\n");
	var leng=0;
	for (i = 0; i < ary.length; i++) {
		if (ary[i].length > leng) {
			leng=ary[i].length;
			}
		}
	if (leng > 50){
		  document.getElementById('idMsgBoxstr').style.fontSize = "9px";
		  document.getElementById('idMsgBoxstr').style.top = "36px";
		  document.getElementById('idMsgBoxstr').style.lineHeight = "130%";
		  }
	else {
		 document.getElementById('idMsgBoxstr').style.fontSize = "13px";
		 document.getElementById('idMsgBoxstr').style.top = "60px";
		 document.getElementById('idMsgBoxstr').style.lineHeight = "20px";
		 }
	if (title == null) { title="Message Box"; }
	if (top == null) { top=160; }
	document.getElementById('idMsgBox').style.display='block';
	document.getElementById('idMsgBox').style.top=top;
	if (left !== null) {
		document.getElementById('idMsgBox').style.left=left;
		}
	document.getElementById('idMsgBoxtitle').textContent=title;
	document.getElementById('idMsgBoxstr').textContent=str;
	}

/* ****************************************************************************
	Select BOX (mpdweb標準モジュールからPOST除外版)
***************************************************************************** */
var OPEN_idsel="";							// OpenBox:id
/* ----------------------------------------------------------------------------
	EventSelectBoxOnclick(idin,idsel) : Event Input , Make Select Box
	 idin  : i  ; Input Areaのid名
	 idsel : i  : Tabel name , {idsel}+{i} ; TabelCell 要素
----------------------------------------------------------------------------- */
function EventSelectBoxOnclick(idin,idsel) {
	if (document.getElementById(idsel).style.display=='block') {
		document.getElementById(idsel).style.display='none';
		if (OPEN_idsel==idsel) { OPEN_idsel=""; }			// 開いているidをClear
		return;
		}
	if (document.getElementById(idin+"tbl")) {
		document.getElementById(idsel).style.display='block';
		EventSelectBoxMark(idin,idsel);
		EventSelectBoxheight(idsel);
		EventSelectBoxClose(idsel);				// 他のBoxをClose
		}
	}

/*
	EventSelectBoxClose(idsel) : Event SelectBox close ; 他BoxClose
	 idsel : i  : Tabel name , {idsel}+{i} ; TabelCell 要素
*/
function EventSelectBoxClose(idsel) {
	if ((OPEN_idsel !=="")&&(OPEN_idsel !==idsel)) {
		if ((document.getElementById(OPEN_idsel))&&(document.getElementById(OPEN_idsel).style.display !=="none")) {
			document.getElementById(OPEN_idsel).style.display='none';
			}
		}
	OPEN_idsel=idsel;														// 開いているidをセット
	}

/*
	EventSelectBoxMark(idin,idsel) : Event Input Mark Select
	 idin  : i  ; Input Areaのid名
	 idsel : i  : Tabel name , {idsel}+{i} ; TabelCell 要素
*/
function EventSelectBoxMark(idin,idsel) {
	for (var i = 0;; i++) {
		if (document.getElementById(idsel+i) == null) { break; }
		if (document.getElementById(idin).innerHTML == document.getElementById(idsel+i).innerHTML) {
			 document.getElementById(idsel+i).style.backgroundColor='#c0c0c0';
			 }
		else if(document.getElementById(idsel+i).style.backgroundColor !=="") {
			 document.getElementById(idsel+i).style.backgroundColor='';
			 }
		}
	}

/*
	EventSelectBoxheight(idsel) : Event SelectBox Height Set ; Windowのsizeで再設定
	 idsel : i  : Tabel name , {idsel}+{i} ; TabelCell 要素
*/
function EventSelectBoxheight(idsel) {
	var maxheight="{$maxheight}";
	var adjust=0;
	var jsevent="";
	eval("jsevent= JSEvent_"+idsel+";");
	if (jsevent !="") { eval(jsevent+";"); }
	if ((maxheight!="")&&(maxheight < 0)) {
		adjust=parseInt(maxheight);
		}
	var def_hight=60;						// Select[Input]毎の高さ設定
	eval("def_hight="+"PROT_"+idsel+"_h;");										// 指定サイズを加味したBoxHight Get 最大:$boxheight
	set_hight=def_hight;
	var pos=parseInt(document.getElementById(idsel).style.top)+set_hight;		// Select Boxの下位置をGet
	if (pos > window.innerHeight) {												// Browser Windowを超えているかチェック
		var hight=set_hight-(pos-window.innerHeight)+adjust;
		if (hight > 44) {					// 小さすぎるとスクロールに難があるので調整しない
			set_hight=hight;
			}
		}
	document.getElementById(idsel).style.height=set_hight+"px";
	}

/* ----------------------------------------------------------------------------
	EventSelectBox(idin,idsel,id,idsubmit) : Event Select
	 idin    : i  : Input Areaのid名 ( var {idin}
	 idsel   : i  : Tabel name , {idsel}+{i} ; TabelCell 要素
	 id      : i  : Click Event Select id
	 idsubmit: i  : Submit id Name "";not Submit
----------------------------------------------------------------------------- */
function EventSelectBox(idin,idsel,id,idsubmit) {
	var str="";
	eval("str="+idin+";");
	document.getElementById(idsel).style.display='none';
	document.getElementById(idin).innerHTML=document.getElementById(id).innerHTML;
	if (document.getElementById(id+"v")) {
		 document.getElementById(idin).value=document.getElementById(id+"v").value;
		 }
	else {
		 document.getElementById(idin).value=document.getElementById(id).innerHTML;
		 }
	if ((idsubmit !=="")||(idsubmit !==null)) {
		if (str !== document.getElementById(idin).innerHTML) {
			 document.getElementById(idsubmit).style.backgroundColor='#009900';
			 document.getElementById(idsubmit).style.color='#CED8F6';
			 }
		else {
			 document.getElementById(idsubmit).style.backgroundColor='';
			 document.getElementById(idsubmit).style.color='';
			 }
		}
	var jsevent="";
	eval("jsp= JSClick_"+idsel+";");eval(jsp);		// 変数から値をGet(項目毎:JSClick_idsel)→値を関数として実行
	if (jsevent !="") { eval(jsevent+";"); }
	}

/* *****************************************************************************
	HTML onLoad Execution
****************************************************************************** */
<?php
/* ----------------------------------------------------------------------------
	Use JS PHP:"$MPC_MONITOR"設定 : Monitorの初期値 & EventNowMusic TimerSet
----------------------------------------------------------------------------- */
$tmp=$_SERVER['HTTP_REFERER'];
$ary = parse_url($tmp);
$myhost = explode(":",$_SERVER['HTTP_HOST'])[0];
$phost="";
if ((isset($ary['host']))&&($ary['host'] !== $myhost)) {		// 他Serverのときは，終了時Postする。
	if (isset($ary['port'])) { $port=":".$ary['port']; }
	$phost=$ary['scheme']."://".$ary['host'].$port;
	}
echo <<<EOM
var MPC_MONITOR="{$MPC_MONITOR}";
var phost="{$phost}";

EOM;
?>
document.addEventListener('DOMContentLoaded', () => {
	var host=document.getElementById('idHostSel').textContent;	// LocalPCでHostが動作している場合に初期Monitorが有効になる
	if ((MPC_MONITOR=="on")&&(host.startsWith('::1,'))) {	// Monitor:on &&LocalPC:Host
		EventMakeModeUp(MPC_MONITOR);
		PostMusicPoint();
		}
	});

/* ----------------------------------------------------------------------------
	EventonLoad() : Event onLoad  Body OnLoad時実行
----------------------------------------------------------------------------- */
function EventonLoad() {
	var result=EventonLoadPath();
	if(result) {
		document.getElementById('idUploadPath').textContent=result;
		ArgAdjustmentRtl('idUploadPathPar');
		document.getElementById('idUpload').style.color='#00ff00';
		}
	}

/* ----------------------------------------------------------------------------
	EventonLoadPath() : User定義関数 :を定義FilePath取得
	PHP変数 : $EvntOnLoad:FilePath取得ルール(JavaScript)
	@return : o  : FilePath , or false
----------------------------------------------------------------------------- */
function EventonLoadPath() {
var path=false;

<?php
	if((isset($_GET["path"]))&&($_GET["path"]!=="")) {
		$path=$_GET["path"];
		$path=str_replace("%DOCROOT%",$MPD_DOCROOT,$path);
		print 'path="'.$path.'";';
		}
?>
	return(path);
	}

/* ----------------------------------------------------------------------------
	ArgAdjustViewport() : DiviceからScaleを求める
----------------------------------------------------------------------------- */
function ArgAdjustViewport() {
	const deviceWidth = window.innerWidth;								// Divice幅Get
	const targetWidth = 460; 											// ContentsWidth(固定)
	const initialScale = deviceWidth / targetWidth;						// Scaleを求める
	const viewportMeta = document.getElementById('viewport-meta');		// viewport metaTagを設定
	viewportMeta.setAttribute('content', `width=device-width, initial-scale=${initialScale}, user-scalable=no`);
//	console.log("initialScale ["+initialScale+"]");
	}
window.onload = ArgAdjustViewport();

/* *****************************************************************************
 	iFrame時のLoad/unLoad
***************************************************************************** */
/* Parent Load Event */
window.addEventListener("load", (event) => {
/* Open Processを記述 */
	});

window.addEventListener('beforeunload', function(e) {
	window.close();
	});

/* Parent Close Button */
window.addEventListener('message', function(event) {
var str=event.data;
	if (str.indexOf('close') >=0) {
		window.close();
		var id = str.split('close:');
		parent.document.getElementById(id[1]).style.display = 'none';
		}
	});
/* Child Close Button */
function EventSelfClose() {
//	alert(phost);
	if(phost !=="") {					// 別Hostから起動時postする。
		window.parent.postMessage("close",phost);
		return;
		}
	var pobj = window.frameElement;		// 自身を参照している iframe 要素を取得
	if (pobj) {
		pobj.parentNode.style.pointerEvents = 'auto';	// 親要素のイベントを再有効化
		pobj.remove();					// 自身の iframe を削除
		}
	window.close();
	}

/* *****************************************************************************
	JavaScript End of Source / Start HTML&PHP Main
***************************************************************************** */
</script>

<!--<body id="idBody" onload="EventonLoad()" style="display:block;">-->
<body id="idBody" onload="EventonLoad()">
<title>Diretta MemoryPlay</title>
<div class=boxon style="position:fixed;top:0px;left:0px;width:480px;height:100%;">
<div class=boxtitle>Diretta:MemoryPlayControl (Web)</div>
<?php
print '<div class=boxtitle style="position:absolute;top:0px;left:340px;;width:100px;font-size:9px;text-align:right;">'.$MY_VERDION.'</div>';
if((isset($_GET["frame"]))&&($_GET["frame"]=="on")) {
echo <<<EOM
<div onclick="EventSelfClose();" class="hedCls">X</div>
EOM;
	}
?>

<style type="text/css">
/*******************************************************************************
	style Sheet
*******************************************************************************/
body { background-color:#000000;color: #ffffff; }
.box {border: 1px solid #888888;position:fixed;top:200px;left:170px;
      width:300px;height:238px;font-size:10p;z-index:120;
      background-color:#2f2f2f;
      display: none;
      }
.boxon {border: 1px solid #404040;position:fixed;top:200px;left:170px;
      width:300px;font-size:12p;z-index:5;
      background-color:#030303;
      display: block;
      }
.boxtitle { position:absolute;top:0px;left:0px;width:460px;height:12px;font-size:12px;background-color:#00008b;color:#b0c4de;line-height:70%;text-align:left;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;padding:8px 10 2px;}
.line  { position:absolute;left:10px;font-size:12px;font-color:#ffffff; }
.hedCls{position:fixed;top:3px;left:460px;height:14px;width:12px;background-color:#c0c0c0;color:#2c2c2c;font-size:12px;padding:0px 2px 3px 5px;cursor:pointer;}
.buttn { position:absolute;left:10px;width:50px;height:14px;font-size:12px;line-height:110%;background-color:#a9a9a9;color:#000000;text-align:center;border-style:none;padding:3px 6 2px;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius: 4px;border: 1px solid #696969;cursor:pointer; }
.buttn:active{ color:#808080; }
.select{ position:absolute;top:1px;left:60px;width:400px;height:20px;cursor:pointer;}
.status{ position:fixed;bottom:2px;width:480px;height:16px;color:#BDBDBD;background-color:#2E2E2E;margin-top:4px;border:1.4px solid #000000;overflow:hidden;resize:none; }
.dsptxt{ position: absolute;font-size:13px;white-space:nowrap;overflow:hidden;line-height:140%;-moz-border-radius: 3px;-webkit-border-radius: 4px;border-radius: 3px;background-color:#dcdcdc;color:#000000;direction:rtl;text-align:left;}

/*.scrbar { overflow: scroll; }*/					/* 常にスクロールバーを表示 */
.scrbar { overflow-y: scroll;overflow-x:hidden; }					/* 常にスクロールバーを表示 */
.scrbar::-webkit-scrollbar { height:8px;width: 8px;} 		/* スクロールバー:トラック部分 スクロールバーの幅 */
.scrbar::-webkit-scrollbar-track { background: #1c1c1c; box-shadow: inset 0 0 1px #2e2e2e; }	/* スクロールバー背景 */
.scrbar::-webkit-scrollbar-thumb { background: #2f4f4f; }		/* スクロールバーつまみ */

.MPStat { border: 2px ridge #242424;position:fixed;top:147px;left:319px;width:60px;height:14px;text-align:center;padding:1px 2px;font-size:11px;-moz-border-radius:3px;-webkit-border-radius:4px; }
.MPTable { position:fixed;top:172px;left:5px;width:476px;height:calc(100vh - 190px);text-align:left;font-size:9px;color:#ffffff;overflow-y:scroll; }
.MPTabletr { height:26px; }
.MPTableth { border: 1px #808080 solid;background:#1c1c1c; }
.MPTabletd { border: 1px #808080 solid;overflow:hidden; }
.MPNowTime { position:absolute;overflow:hidden;text-align:center;font-size:12px;font-weight;width:62px;height:25px;line-height:180%;-moz-border-radius:5px;-webkit-border-radius:5px;border-radius:5px;opacity:0.8;z-index:1; }

.FuncBtn { position:absolute;right:4px;top:30px;width:20px;height:20;border-style:none;-webkit-border-radius:2px;border-radius:2px;transform:rotate(-90deg);background-color:#585858;color:#ffffff;text-align:center;font-size:8p;cursor:pointer;padding:0px 0 6px;}

/* EditDirBox */
.EditDirBox   { background-color:#343434;display:block;overflow-y:auto; }
.EditDirBoxSl { position:absolute;padding: 0 0 0 4px;font-size:12px;letter-spacing:0.03em;word-break:break-all;background-color:#f5f5f5;color:#000000;font-weight:bold;border:0.4px solid #808080;line-height:112%;}
.EditDirBoxTb { caret-color:#343434;font-size:13px;letter-spacing:0.03em;cursor:pointer; }
.EditDirBoxDt { text-overflow:ellipsis;color:#f0ffff;white-space:nowrap; }
.EditDirBoxDt:hover { background-color:#b0c4de;color:#000000; }
.EditDirBoxChd { text-overflow:ellipsis;color:#d3d3d3;white-space:nowrap; }
.EditDirBoxChd:hover { background-color:#b0c4de;color:#000000; }

/* MakeSelectBox */
.SeleBoxin { position:absolute;border:0.4px solid #707070;line-height:100%;text-align:left;font-size:12px;overflow:hidden;white-space:nowrap;cursor:pointer; }
.SeleBoxSl { position:absolute;transform:rotate(-90deg) scale(0.7,1);border:1px solid #707070;margin:1.1px 0 0 0;overflow:hidden;cursor:pointer; }
.SeleBox   { position:absolute;border:1px solid #888888;background-color:#f5f5f5;overflow:auto; }
.SeleBoxDt { height:18px;font-size:12px;color:#000000;overflow:visible;white-space:nowrap; }
.SeleBoxDt:hover { background-color:#b0c4de; }

/*
#idlodingmsg   : 起動待ちディスプレイ
@keyframes spin: 起動待ちディスプレイアクション
*/

#idlodingmsg {
    position: fixed;top:210px;left:210px;z-index:4;
    width: 50px; 				/*ローディングアイコンの横サイズ*/
    height: 50px; 				/*ローディングアイコンの縦サイズ*/
    border-radius: 50%; 		/*CSS3で円を書く*/
    border: 8px solid #ffffff;  /*円に○の白枠をつける*/
    border-right-color: transparent;	/*円の右にC状の空きをつける*/
    animation: spin 1s linear infinite; /*1秒毎にくるくる回転するアニメーション*/
    display: none;
}
@keyframes spin {
    0% { transform: rotate(0deg);   opacity: 0.2; }		/*0%の時は20％の透明度*/
    50%  { transform: rotate(180deg); opacity: 1.0; }	/*50%の時は透明度なし*/
    100%   { transform: rotate(360deg); opacity: 0.2; }	/*100%の時に20％の透明度に戻る*/
	}

</style>
<div class=line style="top:32px;font-size:11px;">Memory Play : wav flac and dsf dff and aif only</div>
<button type=submit onclick="document.getElementById('idconfig').style.display='block';" class="FuncBtn" style="margin: 2px 0px 0px 2px;">...</button>';

FuncBtn
<?php
/*******************************************************************************
	PHP Process
*******************************************************************************/
$result_host=DispMemoryHost();

// Directory Search Box //
$selunload='document.getElementById(\'idEditDirBox\').style.display=\'none\';';
$js= <<<EOM
if(document.getElementById('idEditDir').textContent !=='') {
	document.getElementById('idUploadPath').textContent=document.getElementById('idEditDir').textContent;
	ArgAdjustmentRtl('idUploadPathPar');
	document.getElementById('idUpload').style.color='#00ff00';
	{$selunload}
	}
EOM;
str_replace("\n","",$js);
$js="function () { ".$js." }";

if ((isset($MPC_MONITOR))&&(strtolower($MPC_MONITOR)=="on")) { $idmoncss='color:#008000;'; } else { $idmoncss='color:#000000;'; }
// ------ HTML Header 1 --------------------------------------------------------
echo <<<EOM
<div style="position:absolute;top:107px;left:12px;font-size:10px;">Directory/Files</div>
<div id="idUploadPathPar" class=dsptxt style="top:122px;left:8px;width:356px;height:20px;"><bdi id="idUploadPath"></bdi></div>
<button type=submit class=buttn onclick="document.getElementById('idEditDirBox').style.display='block';document.getElementById('idSelect').onclick={$js};PostSearchRequest();" style=top:122px;left:366px;height:20px;width:50px;">Search</button>
<button id=idUpload type=submit class=buttn onclick="PostUploadRequest();" style=top:122px;left:420px;height:20px;width:50px;background-color:#c0c0c0;">Upload</button>
EOM;

/* ----------------------------------------------------------------------------
	Directory Common Select Box
	idSelect  : onclickにSelectClick後の動作を設定
	            document.getElementById('idSelect').onclick=function () { [js]}
	idEditDir : 選択Pathを表示
	idEditFile: FileをSelect時Fileがセットされる。(Directory選択と区別のため)
----------------------------------------------------------------------------- */
echo <<<EOM
<!-- Directory Select Box Base -->
<div class=box id=idEditDirBox style="position:fixed;top:110px;left:8px;width:462px;height:340px;background-color:#272727;border:1px solid #dcdcdc;z-index:130;">
<div style="position:absolute;top:6px;left:20px;font-size:11px;">Directory&nbsp;Select</div>
<div id="idEditFile" style="position:absolute;top:6px;left:170px;font-size:0px;">xxx</div>
<!-- Directory Select Box -->
<div id="idEditDir" class=EditDirBoxSl style="top:26px;left:10px;width:436px;height:44px;"></div>
<div class=box id=idEditDirSel style="position:absolute;top:51px;left:10px;width:440px;height:218px;background-color:#343434;display:block;"></div>
<button type=submit onclick="" id=idSelect class="buttn" style="position:absolute;bottom:12px;left:10px;width:60px;height:22px;">Select</button>
<input type="button" value="Cancell" onclick="{$selunload}" class="buttn" style="position:absolute;bottom:12px;left:390px;width:60px;height:22px;" />
</div>
EOM;
// ------ HTML Header 2 --------------------------------------------------------
echo <<<EOM
<!-- Controle -->
<button type=submit class=buttn onclick="PostConnectRequest();" style="top:146px;left:6px;height:20px;width:62px;">Connect</button>
<div style="position:absolute;top:150px;left:70px;font-size:9px;">Connect&Play</div>
<button type=submit class=buttn onclick="PostMPSeekRequest();" style="top:146px;left:140px;height:20px;width:48px;">Seek</button>
<button type=submit class=buttn id=idSeekSec onclick="EventSeekSec();" style="top:150px;left:190px;height:16px;width:37px;background-color:#222222;color:#a9a9a9;padding: 1px 0px 1px 0px;">{$MPC_SEEKINIT}</button>
<button type=submit class=buttn onclick="PostMPDisconnectRequest();" style="top:146px;left:230px;height:20px;width:62px;font-size:10px;">Disconnect</button>
<div style="position:absolute;top:150px;left:294px;font-size:9px;">Stop</div>
<button type=submit class=buttn id="idMon"  onclick="EventMusicMonitorClick();" style="top:146px;left:388px;height:20px;width:30px;font-size:10px;{$idmoncss}">Mon.</button>
<button type=submit id="idstatus" class=buttn onclick="PostMPStatusRenew();" style="top:146px;left:420px;height:20px;width:50px;">Status</button>

<div id="idlodingmsg"></div>
<!-- Play位置 -->
<div class=MPNowTime id="idNowTime" style="top:60px;left:406px;"></div>
EOM;

///// Test Line Start Postを実行するので printを表示するにのでテストできる ////////
//print '<div class="line" style="top:600px;width:480px;";>-----------------------------------------------------------<BR>';
//PostMPMusicPoint();		// テスト：現在状態を下段に表示する
//print '<BR>-----------------------------------------------------------</div>';

$status=DispMHStatus($result_host);				// 最下行 Status

DispConfig();

DispMsgBox();							// MessageBox(Form)をDisplay:noneで作成しておく。

echo <<<EOM
</body>
</html>
EOM;

/* ****************************************************************************
	PHP Function
***************************************************************************** */

/* ----------------------------------------------------------------------------
	DispMemoryHost($ghost) : Display MemoryPlayHost/ Target
	$ghost  : i  : MemoryPlay Host "":無条件, Host指定:対応するTargetを対象にする
	@return : o  : Select Diretta MemoryPlay Host
----------------------------------------------------------------------------- */
function DispMemoryHost($ghost="") {
	global $MPC_APPLI,$MP_APPNAME,$MakeSelectBoxJS;

//------- Shell Script --------------------------------
// Command:{Error内容}
// MemoryPlayController -c listの内容
// SelectTarget:{MemoryHost}
// Target:Start 以降にMemoryPlayController -c targetの内容
//  str=(${line// / }) Bash なので明記する"#!/bin/bash"
//  ※Arckは明記しなくても良い
$cmd= <<< EOM
#!/bin/bash
host=\$({$MPC_APPLI} -c list);
if [ \$? -ne 0 ]; then
    echo "Command:Error:list:"\$host
    exit 1
    fi
echo "\$host"
sel_host="";
sel_ok="0";
while IFS= read -r line; do
    str=(\${line// / })
    if [ -n "$ghost" ] && [ "\${str[0]}" = "$ghost" ]; then
       sel_host="\${line}";
       sel_ok="1";
      fi
    if [ "\${sel_ok}" = "0" ] ;then
      clean_line=$(echo "\$line" | tr -d '[:space:]')
      tmp="\${clean_line:0:4}"
      if [ "\$tmp" = "::1," ] ;then
          sel_host="\${line}";
      fi
    fi
    if [ -z "\$sel_host" ]; then
       sel_host="\${line}";
    fi
done <<< "\$host"
target=(\${sel_host// / })
echo "SelectTarget:\${target[0]}"
echo "Target:Start"
targetlist=\$({$MPC_APPLI} -c target \${target[0]});
if [ \$? -ne 0 ]; then
    echo "Command:Error:target:\$targetlist"
    exit 1
    fi
echo "\$targetlist"
EOM;
	$cmdresult=ArgTaskExec("bash -c " . escapeshellarg($cmd));	// Bashを明記"#!/bin/bash"と片方で良いが今後のサンプル
// Command Excution Result Array
//print"<BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>";print_r($cmdresult);
	$arry_host=array();$arry_target=array();$sel_host="";$cmd_err="";
	$ary_sel=0;
	if($cmdresult !==false) {
//print '<div class="line" style="top:600px;width:480px;";>-----------------------------------------------------------<BR>';
		foreach($cmdresult as $key => $val) {
//print '$val['.$val.']<BR>';
			if(strstr($val,"Command:Error:") !== false) {
				$tmp=explode("Command:Error:",$val);
				if (isset($tmp[1])) {
					$cmd_err=$tmp[1];
					}
				continue;
				}
			if(strstr($val,"SelectTarget:") !== false) {
				$tmp=explode("SelectTarget:",$val);
				if (isset($tmp[1])) {
					$sel_host=$tmp[1];
					}
				continue;
				}
			if(strstr($val,"Target:Start") !== false) {
				$ary_sel=1;
				continue;
				}
			if(($ary_sel==0)&&($val!="")) {
				$arry_host[]=$val;
				}
			if (($ary_sel==1)&&($val!="")) {
				$arry_target[]=$val;
				}
			}
//print '------ End ----------------------------</div><BR>';
		}
//print "<BR><BR><BR><BR><BR><BR><BR><BR>";print_r($cmdresult);
// Display Host
	print '<div id="idHostBox">';
	if(($sel_host=="")&&($MP_APPNAME !=="")) {
		 print '<button class=buttn onclick="RequestLoadDisp();RequestByPost(POSTMOD,\'p=mpstart\',function(){ PostMPStatusRenew();RequestUnLoadDisp(); });" style="position:fixed;top:36px;left:400px;width:51px;height:18px;font-size:11px;background-color:#008000;color:#ffffff;">MPHost</button>';
		 }
	else {
		 print '<div id="idHostSel" style="position:fixed;top:35px;left:268px;width:186px;overflow:hidden;text-align:right;font-size:9px;color:#008000;">'.$sel_host.'</div>';
		 }
	print '<div class=buttn onclick="PostGetHostRequest();" id="idHost" style="position:fixed;top:57px;width:40px">Host</div>';
	if($cmdresult !==false) {
		$defstr="";
		$selary["Text"]=array();
		$selary["Value"]=array();
		foreach($arry_host as $key => $val) {
			$ary=explode(" ",$val);
			if(($sel_host!=="")&&(strstr($val,$sel_host) !== false)) { $defstr=$val; }
			$selary["Text"][]=$val;
			$selary["Value"][]=$ary[0];
			}
		}

	$selary["style"]["position"]="position:absolute;";
	$onclick["Click"]='EventHost_Change();';
	$MakeSelectBoxJS[]=MakeSelectBox($selary,$defstr,"idHostIP",57,70,400,"","idHostIP2ndSel",$onclick,"");
	print '<input type=hidden id=idHostIP2ndSel value='.$defstr.' />&thinsp;';		// f(name)={field}(value)を引数に設定	// <button p(name)=list(value)設定

// Display Target
	print '<div class=buttn onclick="PostGetTarget();" style="position:fixed;top:84px;width:40px">Target</div>';
	if($cmdresult !==false) {
		$defstr="";$defstrFst="";
		$selary["Text"]=array();
		$selary["Value"]=array();
		$count=0;
		foreach($arry_target as $key => $val) {
			$ary=explode(" ",$val);
			$selary["Text"][]=$val;
			$selary["Value"][]=$ary[0];
			if(strpos($val,'MemoryPlayHost(Recoder)') === false){
				$defstr=$val;
				}
			if($count==0) {
				$defstrFst=$val;
				}
			$count=$count+1;
			}
		if (($defstr == "")&&($defstrFst !== "")) {
			$defstr=$defstrFst;
			}
		}
	$selary["style"]["position"]="position:absolute;";
	$MakeSelectBoxJS[]=MakeSelectBox($selary,$defstr,"idTarget",84,70,400,"","idTarget2ndSel","","");
	print '<input type=hidden id=idTarget2ndSel value='.$defstr.' />&thinsp;';		// f(name)={field}(value)を引数に設定	// <button p(name)=list(value)設定
	print '</div>';

// Display Status
	if($cmd_err == "list:") {
		 $cmd_err="Not Execute MemoryPlayHost";
		 }
	else if(($cmd_err == "")&&(count($arry_target)==0)) {
		 $cmd_err="Diretta Target Not Ready";
		 }
	else if($cmd_err == "") {
		 $cmd_err="Command exec End(".$sel_host.")";
		 }
	DispStatus($cmd_err);
	return($sel_host);
	}

/* ----------------------------------------------------------------------------
	DispMHStatus($host) : Display MemoryHost
	$host   : i  : 対応するHostの状態&TagList
	@return : o  : Status
----------------------------------------------------------------------------- */
function DispMHStatus($host) {
	global $MPC_APPLI;

$cmd= <<< EOM
echo "GetStatus:Start"
stat=\$({$MPC_APPLI} -c status {$host});
if [ \$? -ne 0 ]; then
    echo "Command:Error:status:"\$host
    exit 1
    fi
echo "\$stat"
echo "GetTagList:Start"
taglist=\$({$MPC_APPLI} -c tag {$host});
if [ \$? -ne 0 ]; then
    echo "Command:Error:tag:"\$host
    exit 1
    fi
echo "\$taglist"
EOM;
	$cmdresult=ArgTaskExec($cmd);

// Command Excution Result Array ] : Command Out: {No} {Sec} {mm:ss} {Title}
	$arry_host=array();$arry_target=array();$sel_host="";$cmd_err="";$status="";$tagary=array();
	$ary_sel=0;
	if($cmdresult !==false) {
		foreach($cmdresult as $key => $val) {
			if(strstr($val,"Command:Error:") !== false) {
				$tmp=explode("Command:Error:",$val);
				if (isset($tmp[1])) {
					$cmd_err=$tmp[1];
					}
				continue;
				}
			if(strstr($val,"GetStatus:Start") !== false) {
				$ary_sel=1;
				continue;
				}
			if(strstr($val,"GetTagList:Start") !== false) {
				$ary_sel=2;
				continue;
				}
			if($ary_sel==1) {
				$status=$val;
				continue;
				}
			if($ary_sel==2) {
				$tagary[]=$val;
				}
			}
		}
	ob_start();
	print '<div id="idTagBox">';
	if($status=="Disconnect") {
		 $css='background-color:#bc611e;color:#ffc0cb;';
		 }
	else if($status=="Play") {
		 $css='background-color:#6b8e23;color:#ffffff;';
		 }
	else {
		 $css='background-color:#00008b;color:#87ceeb;';
		 }
	print '<div id="idMPStat" class=MPStat style="'.$css.'">'.$status.'</div>';
	print '<div id="idMPTag" class="scrbar MPTable">';
	print '<table id="idMPTagTbl" style="font-size:12px;">';
	print '<thead><tr style="height:24px;"><th class=MPTableth style="width:50px;cursor:pointer;">index</th><th class=MPTableth style="width:60px;">Time</th><th class=MPTableth style="width:340px;">Title</th></tr></thead><tbody>';
	ob_end_flush();
	$total=0;$str="";
	foreach($tagary as $key => $val) {
		$tagary=explode(" ",$val,4);
		if($tagary[0] < 0) { $total=$tagary[1]; }		// Total行: "-1 3270 QUIT"
		if(count($tagary)<4) { continue; }
		ob_start();
		print '<tr class=MPTabletr><td class=MPTabletd style="text-align:center;">';
		print '<button type=submit onclick="PostMPSeektagRequest(\''.$tagary[0].'\');" class="buttn MPTabletr" style="width:50px;height:26px;margin:-13px 14px 14px -6px">'.($tagary[0]+1).'</button</td>';
		print '<td class=MPTabletd style="font-size:11px;text-align:center;">'.$tagary[2].'</td>';
		print '<td class=MPTabletd><div style="width:332px;overflow:hidden;white-space:nowrap;text-overflow: ellipsis;">'.$tagary[3].'</div></td>';
		print '<td hidden>'.$key.'</td>';															// 経過Secの隠しArea
		print '<td hidden>'.$key.'</td></tr>';														// 経過Sec(残)の隠しArea
//		print '<td style="font-size:7px">'.$key.'</td>';			// テストは上の2行と入れ替え	// 経過Secの隠しArea
//		print '<td style="font-size:7px">'.$key.'</td></tr>';		// テストは上の2行と入れ替え	// 経過Sec(残)の隠しArea
		ob_end_flush();
		}
	ob_start();
	print "</tbody></table>";
	if(intval($total) !==0) {
		$str=ArgConvTime($total);
		}
	print '<div class="line" id="idMpTotalStr" style="left:55.5px;width:50px;text-align:right;";>'.$str.'</div>';
	print '<div hidden class="line" id="idMpTotal" style="left:100px;width:50px;text-align:right;";>'.$total.'</div>';
	print "</div></div>";
	ob_end_flush();
	return($status);
	}

/* ----------------------------------------------------------------------------
	DispStatus($message) : Display Status
	$message: i  ; Display Message String
----------------------------------------------------------------------------- */
function DispStatus($message) {
echo <<< EOM
<textarea onclick="this.blur();" cols="30" rows="1" readonly="" id="stdout" class=status>
{$message}
</textarea>
EOM;

	}

/* ----------------------------------------------------------------------------
	DispMsgBox() : Display MessageBox (Init)
----------------------------------------------------------------------------- */
function DispMsgBox() {
	$width=360;
	print '<div id=idMsgBox class=box style="width:'.$width.'px;height:160px;position:fixed;top:200px;left:'.((480-$width)/2).'px;background-color:#f5f5f5;z-index:1000;display:none;">';
	print '<div id=idMsgBoxtitle class=boxtitle align=left style="width:'.($width-20).'px;cursor:pointer;"></div>';
	print '<div id=idMsgBoxstr align=center style="overflow:hidden;word-wrap: break-word;white-space: pre-wrap;text-overflow:ellipsis;width:'.($width-40).'px;height:100px;font-size:15px;position:absolute;top:60px;left:20px;line-height:20px;text-align:center;color:#000000;"></div>';
	print '<input type="button" name="Submit" class="buttn" value="OK" onclick="document.getElementById(\'idMsgBox\').style.display=\'none\';" style="position:absolute;top:120px;left:'.(($width/2)-20).'px;font-size:12px;width:60px;height:24px;" />';
	print '</div>';
	}


/* *****************************************************************************
	PHP Support Library
****************************************************************************** */

/* ----------------------------------------------------------------------------
	ArgTaskExec($cmd) : Task Exec
	$cmd   : i  ; Command String
----------------------------------------------------------------------------- */
function ArgTaskExec($cmd) {
	$reslt=false;
	exec($cmd,$output,$rescode);
	if($rescode !==false) {
		$reslt=$output;
		}
	return($reslt);
	}

/* ----------------------------------------------------------------------------
	ArgConvTime($sec) : Sec to Edit Time
	$sec    : i  ; Seconds
	@rettun : o  : hh:mm:ss or mm:ss
----------------------------------------------------------------------------- */
function ArgConvTime($sec) {
	$hh = floor($sec / 3600);
	$mm = floor(($sec / 60) % 60);
	$ss = floor($sec % 60);
	if($hh > 0) {
		 $str=sprintf("%0d:%02d:%02d",$hh,$mm,$ss);
		 }
	else {
		 $str=sprintf("%02d:%02d",$mm,$ss);
		 }
	return($str);
	}

/*******************************************************************************
	MakeSelectBox($method,$select,$defstr,$idin,$top,$left,$width,$maxheight,$onclick,$idsubmit) : Make inpit / Select Box
	 $select   : i  : <Tabel>作成パラメータ
	                  get時 :Select Box Text Array ["Text"]/["Value"]
	                  post時:["Query"]:mpd_list(field);Filed名, ["Sort"],["PostStr"],Post形式 ["Text"]/["Value"]追加配列,$select ["Replase"]["Sour"]/["Replase"]["Dist"]:Value置換,["Postjs"]["Init"]/["Postjs"]["End"]:AddJS ,["Errhtml"]:HTML Message
	                  共通$select["style"]["position"]:style:positionをセット
	 $defstr   : i  : Input Default String  : 選択したTextと異なる場合,$idsubmitの要素のbackground-colorを変化させる
	 $idin     : i  : Input Areaのid名 (SelectBoxは「$idin."Box"」)
	 $top      : i  : Input Area : Position Top
	 $left     : i  : Input Area : Position Left
	 $width    : i  : Input Area : Width
	 $maxheight: i  : Select Box Max Height , 0>$maxheight:最大時上げ幅, "":No Specify  : 共通,複数回Callしても初回の値を使用 (0>時,EventSelectBoxheight()でjs項目maxheight(同じ名称)で使用)
	 $idsubmit : i  : SubmitInput id  指定時,$defstr(DefaultString)と選択したTextと異なる場合,background-colorを変化させる
	 $onclick  : i  : [Event] onclick時,Postを含め,毎回通過のEventSelectBoxheight()で実行)
	                  [Click] onclick時,Click後,EventSelectBox()で実行 Select単位に設定可
	 $style    : i  : Select Input Style
	 @return   : o  : SelectBox Style JSP Function Name (SelectBoxのStyleを生成するJSP関数 Post時実行すれば生成できる。)
	                  PostでSelectBoxを生成すると，Select枠の変動が生成できなくなるのでPost最終でFunctionを実行する。
※タブレット操作時,Selectで画面全体に表示されるので鬱陶しいため自前，SelectBox
*******************************************************************************/
function MakeSelectBox($select,$defstr,$idin,$top,$left,$width,$maxheight,$idsubmit="",$onclick="",$style="") {
	global $MAKESELECTBOX;

	$height=20;$boxheight=60;					// $height:20:Select(Input)Height $boxheight:Default BoxHeight(Boxを生成時に設定:最大で$maxheight)
	$idsel="grp".$idin;
	$idseltbl=$idin."tbl";
	$val=$defstr;
	$i=array_search($defstr,$select["Text"],true);		// Defaultの$selectValueをSearch
	if (($i !==false)&&(isset($select["Value"]))&&(isset($select["Value"][$i]))) {
		$val=$select["Value"][$i];
		}
	print '<button type="text" id="'.$idin.'" value="'.$val.'" onclick="this.blur();EventSelectBoxOnclick(\''.$idin.'\',\''.$idsel.'\');" class="SeleBoxin" style="top:'.$top.'px;left:'.$left.'px;width:'.($width-19).'px;height:'.$height.'px;'.$style.'">'.$defstr.'</button>';
	print '<button type="text" onclick="this.blur();EventSelectBoxOnclick(\''.$idin.'\',\''.$idsel.'\');" class="SeleBoxSl" style="top:'.$top.'px;left:'.($left+$width-24.3).'px;width:'.($height+8.6).'px;height:18px;'.$style.'">&lt;</button>';
	$boxheight=MakeSelectBoxDetail("none",$select,$idin,$top,$left,$width,$maxheight,$idsubmit);
	$position="position:fixed";
	if ((isset($select["style"]))&&(isset($select["style"]["position"]))) {
		$position=rtrim($select["style"]["position"],";");
		if ($position !=="") { $position=$position.";"; }
		}
	$js_event="";$js_click="";$js_change="";
	if (is_array($onclick)) {
		if (isset($onclick["Event"])) {				// Postを含め,毎回通過のEventSelectBoxheight()で実行)
			 $js_event=$onclick["Event"];
			 }
		else if (isset($onclick["Click"])) {		// Click後,EventSelectBox()で実行 ("<select"のEventに似せている)
			 $js_click=$onclick["Click"];
			 }
		}
$funcname="LoadSelectBox_".$idin;
$tmp= <<<EOM
<script type="text/javascript">
{$funcname}();
function {$funcname}() {
	{$idin}='{$defstr}';
	POST_{$idin}=0;
	PROT_{$idsel}_h={$boxheight};
	JSEvent_{$idsel}="{$js_event}";
	JSClick_{$idsel}="{$js_click}";
	}
</script>
EOM;
	$tmp=str_replace("\n","",$tmp);
	print $tmp;
	return($funcname);
	}

/* ----------------------------------------------------------------------------
	MakeSelectBoxDetail($select,$idin,$top,$left,$width,$maxheight,$idsubmit) : Make inpit / Select Box Detail
	 $disp     : i  : Select Box Display "none"|"block"
	 $select   : i  : Select Box Text Array ["Text"]/["Value"]
	 $idin     : i  : Input Areaのid名 (SelectBoxは「$idin."Box"」)
	 $top      : i  : Input Area : Position Top
	 $left     : i  : Input Area : Position Left
	 $width    : i  : Input Area : Width
	 $maxheight: i  : Select Box Max Height "":No Specify
	 $idsubmit : i  : SubmitInput id  指定時,$defstr(DefaultString)と選択したTextと異なる場合,background-colorを変化させる
	 @return   : o  : Select Box Height
----------------------------------------------------------------------------- */
function MakeSelectBoxDetail($disp,$select,$idin,$top,$left,$width,$maxheight,$idsubmit="") {
	$height=20;
	$idsel="grp".$idin;
	$idseltbl=$idin."tbl";
	$cnt=count($select["Text"]);
	$boxheight=$cnt*(18+4)+6;
	if (($maxheight !=="")&&($maxheight > 0)&&($maxheight < $boxheight)) {			// 指定Max Height超過時,側近から再計算
		$maxheight=(($maxheight -6)/(18+4))*(18+4)+6;
		$boxheight=$maxheight;
		}
	print '<div id="'.$idsel.'" class="SeleBox scrbar" style="top:'.($top+$height+1).'px;left:'.$left.'px;width:'.($width).'px;height:'.($boxheight+4).'px;cursor:pointer;display:'.$disp.';z-index:1;">';
	if ((is_array($select["Text"]))&&(count($select["Text"]) > 0)) {
		print '<table id="'.$idseltbl.'" >';
		foreach($select["Text"] as $key => $val) {
			$id=$idsel.$key;
			$str='';
			if ((isset($select["Value"]))&&(isset($select["Value"][$key]))) {
				$str='<input type="text" id="'.$id.'v" value="'.$select["Value"][$key].'" style="display:none;">';				// Value用の項目
				}
			print '<tr><td><div id="'.$id.'" onclick="EventSelectBox(\''.$idin.'\',\''.$idsel.'\',\''.$id.'\',\''.$idsubmit.'\');" class="SeleBoxDt" style="width:'.($width-6).'px;">'.$val.'</div>'.$str.'</td></tr>';
			}
		print '</table>';
		}
	print '</div>';
	return($boxheight);
	}

/*******************************************************************************
	DispConfig() : Display Make Config
*******************************************************************************/
function DispConfig() {
	global $MPC_CONFIGPATH,$MPC_PATH,$MPC_APPNAME,$MPC_MONITOR,$SEL_HOMEDIR,$MPD_DOCROOT;

if(file_exists($MPC_CONFIGPATH)) {
	 $comstr="* Contents of ".basename($MPC_CONFIGPATH);
	 require_once($MPC_CONFIGPATH);
	 $dirctry=$MPC_PATH;
	 $appname=$MPC_APPNAME;
	 $monitor=$MPC_MONITOR;
	 $homedir=$SEL_HOMEDIR;
	 $docroot=$MPD_DOCROOT;
	 }
else {
	 $comstr="* Looking for /home/&nbsp;|&nbsp;/usr/";
	 $dirctry="";
	 $result = `find /home -name MemoryPlayController;find /usr -name MemoryPlayController`;
	 if(($result)&&($result!=="")) {
		$dirctry=dirname($result);	// Mpd Session id Library
		}
	 $appname="MemoryPlayController";
	 $monitor="on";
	 $homedir="/mnt/NAS/music/";
	 if(!is_dir($homedir)) {
		$homedir="/";
		}
	 $docroot="/mnt/";
	 if(!is_dir($docroot)) {
		$docroot="";
		}
	 }

echo <<< EOM
<script type="text/javascript">
/* -----------------------------------------------------------------------------
	EventMakeConfig(): Make, Post
------------------------------------------------------------------------------ */
function EventMakeConfig() {
	var mpcPath=document.getElementById('MPC_PATH').value;
	var mpcAppName=document.getElementById('MPC_APPNAME').value;
	var mpcMonitor=document.getElementById('MPC_MONITOR').value;
	var selHomeDir=document.getElementById('SEL_HOMEDIR').value;
	var selDocRoot=document.getElementById('MPD_DOCROOT').value;
	mpcMonitor = mpcMonitor.toLowerCase();
	if ((mpcMonitor !== "on")&&(mpcMonitor !== "off")) {
		RequestMsgBox('MakeConfig Message','MPC_MONITOR Input Error "on" or "off"');
		return;
		}
	var post='p=makeconfig&MPC_PATH='+mpcPath+'&MPC_APPNAME='+mpcAppName+'&MPC_MONITOR='+mpcMonitor+'&SEL_HOMEDIR='+selHomeDir+'&MPD_DOCROOT='+selDocRoot;
	RequestByPost(POSTMOD,post,function(){  });
	}

/* -----------------------------------------------------------------------------
	PostSearchRequest(id) : Post Request : Directory Search
	Request:Path
------------------------------------------------------------------------------ */
function PostMakePathRequest(id) {
	path="/";
	if(id=="MPC_PATH") {
		 document.getElementById('idSelect').onclick=function(){
				document.getElementById('idEditDirBox').style.display='none';
				var fileobj=document.getElementById('idEditFile');
				if (fileobj.textContent !=="") {
					 document.getElementById('MPC_APPNAME').value=fileobj.textContent;
					 var dirpath=document.getElementById('idEditDir').textContent;
					 var leng=dirpath.lastIndexOf(fileobj.textContent);
					 dirpath=dirpath.substring(0,leng);
					 document.getElementById(id).value=dirpath;
					 }
				else {
					 document.getElementById(id).value=document.getElementById('idEditDir').textContent;
					 }
				};
		 }
	else if(id=="SEL_HOMEDIR") {
		 document.getElementById('idSelect').onclick=function(){
				document.getElementById('idEditDirBox').style.display='none';
				var fileobj=document.getElementById('idEditFile');
				if (fileobj.textContent !=="") {
					 var dirpath=document.getElementById('idEditDir').textContent;
					 var leng=dirpath.lastIndexOf(fileobj.textContent);
					 dirpath=dirpath.substring(0,leng);
					 document.getElementById(id).value=dirpath;
					 }
				else {
					 document.getElementById(id).value=document.getElementById('idEditDir').textContent;
					 }
				};
		 }
	else if(id=="MPC_APPNAME") {
		 path=document.getElementById('MPC_PATH').value;
		 document.getElementById('idSelect').onclick=function(){
				document.getElementById('idEditDirBox').style.display='none';
				var fileobj=document.getElementById('idEditFile');
				if (fileobj.textContent !=="") {
					 document.getElementById('MPC_APPNAME').value=fileobj.textContent;
					 }
				}
		 }
	else if(id=="MPD_DOCROOT") {
		 document.getElementById('idSelect').onclick=function(){
				document.getElementById('idEditDirBox').style.display='none';
				var fileobj=document.getElementById('idEditFile');
				if (fileobj.textContent !=="") {
					 var dirpath=document.getElementById('idEditDir').textContent;
					 var leng=dirpath.lastIndexOf(fileobj.textContent);
					 dirpath=dirpath.substring(0,leng);
					 document.getElementById(id).value=dirpath;
					 }
				else {
					 document.getElementById(id).value=document.getElementById('idEditDir').textContent;
					 }
				};
		 }
	else {
		 document.getElementById('idEditDirBox').style.display='none';
		 document.getElementById('idSelect').onclick=function(){
				document.getElementById(id).value=document.getElementById('idEditDir').textContent;
				document.getElementById('idEditDirBox').style.display='none';
				};
		 }
	var path=encodeURIComponent(path);
	RequestByPost(POSTMOD,'p=getdir&dir='+path+'&exc=off');
	}

</script>
EOM;
/* -----------------------------------------------------------------------------
	DispConfig : HTML
------------------------------------------------------------------------------ */
echo <<< EOM
<div id="idconfig" class=box style="top:54px;left:60px;width:370px;height:440px;line-height:110%;background-color:#060606;">
<div class=boxtitle style="width:350px;">DirettaMemoryPlayL:Configuration</div>
	<div class=line style="top:40px;left:20px;width:350px;">
	<label for="MPC_PATH" >MemoryPlayControllerPath&nbsp;(MPC_PATH)</label><br>
	<input type="text" id="MPC_PATH" name="MPC_PATH" value="{$dirctry}" style="width:300px;"><button onclick="document.getElementById('idEditDirBox').style.display='block';PostMakePathRequest('MPC_PATH');" style="width:30px;cursor:pointer;">...</button><br>{$comstr}<br><br>

	<label for="MPC_APPNAME">MemoryPlayControllerFileName&nbsp;(MPC_APPNAME)</label><br>
	<input type="text" id="MPC_APPNAME" name="MPC_APPNAME" value="{$appname}"><button onclick="document.getElementById('idEditDirBox').style.display='block';PostMakePathRequest('MPC_APPNAME');" style="width:30px;cursor:pointer;">...</button><br><br>

	<label for="MPC_MONITOR">Monitor&nbsp;(MPC_MONITOR)</label><br>
	<input type="text" id="MPC_MONITOR" name="MPC_MONITOR" value="{$monitor}" style="width:50px;">&nbsp;on|off (Convert uppercase to lowercase)<br><br>

	<label for="SEL_HOMEDIR">MusicFilePath&nbsp;(SEL_HOMEDIR)</label><br>
	<input type="text" id="SEL_HOMEDIR" name="SEL_HOMEDIR" value="{$homedir}" style="width:200px;"><button onclick="document.getElementById('idEditDirBox').style.display='block';PostMakePathRequest('SEL_HOMEDIR');" style="width:30px;cursor:pointer;">...</button><br><br>

	<label for="MPD_DOCROOT">MPDWEB&nbspDocumentRootPath&nbsp;(MPD_DOCROOT)</label><br>
	<input type="text" id="MPD_DOCROOT" name="MPD_DOCROOT" value="{$docroot}" style="width:200px;"><button onclick="document.getElementById('idEditDirBox').style.display='block';PostMakePathRequest('MPD_DOCROOT');" style="width:30px;cursor:pointer;">...</button><br>* For use with mpdweb. Add and generate Path<br><br>
	</div>
<div class=line style=";position:absolute;bottom:20px;left:20px;width:350px;">
<div class=line style="left:-2px;bottom:30px;font-size:9px;color:#66cdaa;">Make:{$MPC_CONFIGPATH}</div>
	<button type="submit" onclick="EventMakeConfig();" style="cursor:pointer;">Make</button>
	<button type="submit" onclick="document.getElementById('idconfig').style.display='none';" style="position:absolute;right:30px;cursor:pointer;">Close</button>
	</div>
</div>

EOM;

	}

//----- Source End --------------------------------------------------------------
?>
