<?php
$CONFPATH = '/etc/upmpdcli.conf';
$MODULE = 'upmpdcli';
$MY_VER_UPNP=basename(__FILE__,"")." 1.0 (10.06.2025)";
/***************************************************************************************
	upmpdcli-qobuz Accunt Setting
	http://{Host}/mpdcliconf.php

	upmpdcli Qobuz Accunt Input/Update
***************************************************************************************/
/*  ------------------------------------------------------------------------------------
	Post Process
---------------------------------------------------------------------------------------*/
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	PostUpdat();
	exit;
	}

/*  ------------------------------------------------------------------------------------
	PostUpdat() : upmpdcli update

  ※preg_replace: 正規表現
	$configContent = preg_replace('/^\s*qobuzuser\s*=.*$/m','${1}qobuzuser = ' . $qobuzuser,$configContent,1);
    先頭から一致,qobuzuser = {Accunt} 1行対象にする
  ※shell 実行Form
	echo {su pass} | sudo -S sh -c 'ShellCommand'
	ShellCommand : cat {OutputString} | tee {OutputFilePath} > /dev/null
---------------------------------------------------------------------------------------*/
function PostUpdat() {
	global $CONFPATH,$MODULE;

	$matstr=array("0"=> '/^\s*#\s*{key}\s*=\s*([^\s]+)/m'	// "0":Comment行		// $matstr:正規表現Match
				 ,"1"=> '/^\s*{key}\s*=\s*([^\s]+)/m');		// "1":Live
	$repstr=array("0"=> '/^\s*#\s*{key}\s*=.*$/m'			// Key:$matstrに対応	// $repstr:正規表現Replase
				 ,"1"=> '/^\s*{key}\s*=.*$/m');
	$readbuffer = file_get_contents($CONFPATH);			// upmpdcli.confをGet
	$configContent=$readbuffer;
	foreach($_POST as $item => $val) {
		if($item == 'confirmCode') {
			continue;
			}
		if($val =="") {									// Val(値)がない場合コメントにする
			$str=str_replace('{key}',$item,$matstr[1]);
			if (preg_match($str,$configContent,$matches)) {
				$repexp=str_replace('{key}',$item,$repstr[1]);
				$configContent = preg_replace($repexp,'${1}#${2}',$configContent);
				}
			continue;
			}
		$repexp="";
		foreach ($matstr as $key => $mat) {				// $matstr:"# qobazuser = "," qobazuser = "どちらと一致するかチェック
			$str=str_replace('{key}',$item,$mat);
			if (preg_match($str,$configContent,$matches)) {		// Comment→Liveの順に比較しLiveがあれば使用
				if(isset($matches[1])) {
					$repexp=str_replace('{key}',$item,$repstr[$key]);
					}
				}
			}
		if($repexp !=="") {								// 有効行1行置換する
			 $configContent = preg_replace($repexp,'${1}'.$item.' = '.$val,$configContent,1);
			 }
		else {											// Keyがない場合最後に行を追加
			 $configContent=rtrim($configContent)."\n$item=$val\n";
			 }
		}
	$cmdsudo="";
	if ((isset($_POST['confirmCode']))&&($_POST['confirmCode']!=="")) {
		$cmdsudo='echo '.$_POST['confirmCode'].' | sudo -S ';
		}
	if($configContent==$readbuffer) {					// 変更がなければ終了
		print "No changes, so no updates";
		return;
		}

	if($cmdsudo !=="") {								// sudo Password""の場合chmod/Backup作成しない
		$cmdstr=$cmdsudo."chmod 0666 ".$CONFPATH;
		exec($cmdstr,$result,$retval);
		if ($retval === 0) { }
		else {
			 print "Failed chmod,Check sudo password\n";
			 return;
			 }
		$cmdstr="sudo cp ".$CONFPATH." ".$CONFPATH.".bak;";
		exec($cmdstr,$result,$retval);
		}
	$perms = substr(sprintf('%o', fileperms($CONFPATH)), -4);	// 書き込み権限チェック
	$owner  = (int) $perms[1]; // 所有者
	$group  = (int) $perms[2]; // グループ
	$others = (int) $perms[3]; // その他
	if (($owner & 2) && ($group & 2) && ($others & 2)) { } else {
	   	print 'Check:'.$CONFPATH." No write permission　!!\n";
		return;
		}
	// 入力内容書き込み : Webでsudo禁止している場合,sudoなしで行うのでshellでConf Faleに直書き込む
$cmdstr = <<<SHELL
cat << EOF | tee {$CONFPATH} > /dev/null
{$configContent}
EOF
SHELL;
	exec($cmdstr,$result,$retval);
	if ($retval === 0) {
		 print "Config [$CONFPATH] updated successfully!";
		 if($cmdsudo =="") {								// sudo Password""の場合chmod変えない
			 print '<BR>sudo not run,'.$MODULE.' manually restart';
			 }
		 }
	else {
		 print "Failed to update config.";
		 }
	if($cmdsudo !=="") {								// sudo Password""の場合chmod変えない
		$cmdstr="sudo chmod 0644 ".$CONFPATH;
		exec($cmdstr,$result,$retval);
		$cmdstr="sudo systemctl restart ".$MODULE;
		exec($cmdstr,$result,$retval);
		}
	}

/***************************************************************************************
	HTML Definition
***************************************************************************************/
?>
<!DOCTYPE html>
<html lang="ja"><link rel="shortcut icon" href="./mpdwebfavicon.ico"><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" ><meta http-equiv="Expires" content="1000">
<meta id="idMeta" name="viewport" name="viewport" content="width=device-width,initial-scale=1.4,maximum-scale=1.7">
<script type="text/javascript">
/* View Port 設定 */
SCR_WIDTH=450;
var getDevice = (function(){
		var ua = navigator.userAgent;
		if(ua.indexOf('iPhone') > 0 || ua.indexOf('iPod') > 0 || ua.indexOf('Android') > 0 && ua.indexOf('Mobile') > 0){
			 return 'sp';
			 }
		else if(ua.indexOf('iPad') > 0 || ua.indexOf('Android') > 0){
			 return 'tab';
			 }
		else {
			 return 'other';
			 }
		})();
if ((getDevice == 'sp' )||(getDevice == 'tab' )){
	 scale=Math.floor((window.outerWidth/SCR_WIDTH*100)/100;	// 幅比率で表示(小数3位切り捨て)
	 var viewportContent="width=380,initial-scale="+String(scale)+",maximum-scale=1.7";
	 document.getElementById('idMeta').setAttribute('content',viewportContent);
	 }
</script>
<head>
    <title>UpMpdCli-Qobuz Config</title>
</head>
<body>
<style type="text/css">
body  { background-color:#000000;color:#ffffff;font-size:12px; }
form  { position:fixed;top:10px;left:20px; }
label { position:absolute;top:40px;left:10px; }
input { position:absolute;top:40px;left:140px; }
.formti { font-size:14px;color:#fffff0; }
.title  { position:absolute;top:38px;left:2px;font-size:13px; }
.notes  { position:absolute;top:232px;width:100px;left:334px;font-size:10px; }
.cf     { position:absolute;top:270px;left:10px;width:160px;color:#ffdab9; }
.submit { position:absolute;top:270px;left:260px; }
.Modal  { position:fixed;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,0.5);display:none; }
.boxcs  { position:fixed;top:20px;left:80px;width:300px;height:130px;text-align:center;background:#282828; border-radius:6px;padding:20px; margin:100px auto; }
.boxti  { position:absolute;top:10px;left:20px;font-size:14px;color:#fffff0; }
.boxsb  { position:absolute;top:40px;left:20px;fontsize;9px;color:#ff69b4; }
.boxcf  { position:absolute;top:100px;left:40px;fontsize;9px;color:#ffdab9; }
.boxlb  { position:absolute;top:72px;left:20px; }
.boxin  { position:absolute;top:70px;left:140px; }
.boxok  { position:absolute;bottom:20px;left:40px; }
.boxng  { position:absolute;bottom:20px;right:40px; }
.ver    { position:fixed;top:6px;left:300px;font-size:9px;color:#a9a9a9; }
.host   { position:fixed;top:20px;left:300px;font-size:9px;color:#ffffff; }
.status { position:fixed;top:310px;left:30px;margin-top:1em;color:#3cb371; }
</style>
<?php
/*  ------------------------------------------------------------------------------------
	Main PHP Process (HTML:Body)
---------------------------------------------------------------------------------------*/
$friendlyname="";$mpdhost="";$mpdport="";
$qobuzuser="";$qobuzpass="";$qobuzformatid="";$ermsg="";
$configContent = file_get_contents($CONFPATH);			// upmpdcli.confをGet
if($configContent===false) {
	$ermsg=$CONFPATH.":does not exist";
	}
if (preg_match('/^\s*friendlyname\s*=\s*(.+)$/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$friendlyname = $matches[1];
		}
	}

if (preg_match('/^\s*mpdhost\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$mpdhost = $matches[1];
		}
	}
if (preg_match('/^\s*qobuzpass\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$qobuzpass = $matches[1];
		}
	}
if (preg_match('/^\s*mpdport\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$mpdport = $matches[1];
		}
	}

if (preg_match('/^\s*qobuzuser\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$qobuzuser = $matches[1];
		}
	}
if (preg_match('/^\s*qobuzpass\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$qobuzpass = $matches[1];
		}
	}
if (preg_match('/^\s*qobuzformatid\s*=\s*([^\s]+)/m', $configContent, $matches)) {
	if(isset($matches[1])) {
		$qobuzformatid = $matches[1];
		}
	}

/*
	Make HTML:Body
*/
$serverip=$_SERVER['SERVER_ADDR'];
$cmdstr=$MODULE." -v";
exec($cmdstr,$result,$retval);
$upmpdcli_ver=implode($result);

$disabled="";
if($ermsg !=="") {
	$disabled="disabled";
	}

echo <<<EOM
<div class="ver">{$MY_VER_UPNP}</div>
<div class="host">config server:{$serverip}</div>
<div class="host" style="top:31px">{$upmpdcli_ver}</div>
<form id="configForm"><!-- for/nameはupmpdcli.confと同じ名称にする -->
	<div class="formti"> upmpdcli-qobuz Accunt Setting</div><br>
	<div class="title">Renderer</div>
	<label for="friendlyname" style="top:62px;">FriendlyName</label>
	<input type="text" id="friendlyname" name="friendly Name" value="{$friendlyname}"  style="top:60px;"><br>
	<label for="mpdhost" style="top:92px;">mpd Host</label>
	<input type="mpdhost" id="mpdhost" name="mpdhost" value="{$mpdhost}" style="top:90px;"><br>
	<div class="notes" style="top:94px;">blank or localhost</div>
	<label for="mpdport" style="top:122px;">mpd Port</label>
	<input type="text" id="mpdport" name="mpdport" value="{$mpdport}" style="top:120px;"><br>
	<div class="notes" style="top:126px;">blank or 6600</div>
	<div class="title" style="top:146px;">upmpdcli-Qobuz</div>
	<label for="qobuzuser" style="top:172px;">Qobuz User</label>
	<input type="text" id="qobuzuser" name="qobuzuser" value="{$qobuzuser}"  style="top:170px;"><br>
	<label for="qobuzpass" style="top:202px;">Qobuz Password</label>
	<input type="password" id="qobuzpass" name="qobuzpass" value="{$qobuzpass}" style="top:200px;"><br>
	<label for="qobuzformatid" style="top:232px;">Qobuz Format ID</label>
	<input type="text" id="qobuzformatid" name="qobuzformatid" value="{$qobuzformatid}" style="top:230px;"><br>
	<div class="notes" style="top:235px;">MaxLevel:27</div>
	<div class="cf" style="">Blanks are comment lines</div>
	<button type="submit" {$disabled} class="submit">Update</button>
</form>

<!-- sudo password input -->
<div id="codeModal" class="Modal">
  <div class="boxcs">
    <div class="boxti">Confirmation Box</div>
    <div class="boxsb">No password, no permissions, no backup!</div>
	<div class="boxlb" style="font-size:14px;">sudo password</div>
    <input type="text" id="codeInput" class="boxin">
    <div class="boxcf">sudo permissions persist for a while</div>
    <button id="confirmBtn" class="boxok">OK</button>
    <button id="cancelBtn" class="boxng">Cancel</button>
  </div>
</div>

<div id="message" class="status" style="">{$ermsg}</div><!-- Status Message Area -->
EOM;

/***************************************************************************************
	JSP Process
***************************************************************************************/
$MODPOST=$_SERVER["SCRIPT_NAME"];
echo <<<EOM
<script>
const form = document.getElementById('configForm');
const modal = document.getElementById('codeModal');
const codeInput = document.getElementById('codeInput');
const confirmBtn = document.getElementById('confirmBtn');
const cancelBtn = document.getElementById('cancelBtn');
let pendingFormData = null;

/*  ------------------------------------------------------------------------------------
	EventListener
---------------------------------------------------------------------------------------*/
/*
	Main Form Update Botton EventListener
*/
form.addEventListener('submit', function(e) {
	e.preventDefault();
	pendingFormData = new FormData(this);
	const qobuzVal = pendingFormData.get('qobuzformatid');		// "qobuzformatid" の値を取得
	if (qobuzVal !== null && qobuzVal.trim() !== '') {			// 入力されていれば範囲チェックを行う
		const formatIdValue = parseInt(qobuzVal, 10);
		if (isNaN(formatIdValue) || formatIdValue < 1 || formatIdValue > 27) {
			document.getElementById('message').textContent = "qobuzformatid must be specified in the range of 1 to 27.";
			return;
			}
		}
	codeInput.value = '';
	document.getElementById('message').textContent = "";
	modal.style.display = 'block';					// モーダル表示
	});

/*
	ConfirmBox Cancel Botton EventListener
*/
cancelBtn.addEventListener('click', function() {
	modal.style.display = 'none';
	pendingFormData = null;							// POST中止
	});

/*
	ConfirmBox OK Botton EventListener
*/
confirmBtn.addEventListener('click', function() {
	const code = codeInput.value.trim();
	modal.style.display = 'none';

	pendingFormData.append('confirmCode', code);	// POST 直前に確認コードを追加
	fetch('{$MODPOST}', {
		method: 'POST',
		body: pendingFormData
		})
	.then(response => response.text())
	.then(data => {
		document.getElementById('message').innerHTML = data;
		})
	.catch(error => {
		document.getElementById('message').textContent = 'Error: ' + error;
		});
	});
</script>
EOM;
//----- Source End --------------------------------------------------------------
?>
</body>
</html>
